<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: admin/users.php
 * Description: Управление списком пользователей системы.
 */

require_once '../system/db.php';
if (!isAdmin()) exit("Access Denied");

$result = $mysqli->query("SELECT id, username, role FROM users ORDER BY id DESC");

include '../system/header.php';
?>

<article>
    <header>
        <nav>
            <ul><li><strong>Список пользователей</strong></li></ul>
            <ul><li><a href="/admin/index.php" class="secondary"><i class="fa-solid fa-chevron-left"></i> Назад</a></li></ul>
        </nav>
    </header>

    <table role="grid">
        <thead>
            <tr>
                <th>ID</th>
                <th>Логин</th>
                <th>Роль</th>
                <th>Действие</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?= $row['id'] ?></td>
                <td><?= _e($row['username']) ?></td>
                <td><mark><?= $row['role'] ?></mark></td>
                <td>
                    <i class="fa-solid fa-pen-to-square" style="cursor:pointer; color: var(--pico-primary);"></i>
                    <i class="fa-solid fa-trash" style="cursor:pointer; color: #e74c3c; margin-left: 10px;"></i>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</article>

<?php include '../system/footer.php'; ?>
