<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: users/staff.php
 * Description: Улучшенный список администрации с поддержкой аватаров и живым статусом.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

$page_title = "Администрация — LaiCMS";
include '../system/header.php';

// Получаем расширенные данные команды
$staff = $mysqli->query("SELECT id, username, role, last_seen, avatar FROM users WHERE role IN ('admin', 'mod') ORDER BY role ASC, username ASC");
?>

<style>
    .staff-card { transition: transform 0.2s, box-shadow 0.2s; border-top: 4px solid var(--pico-primary); }
    .staff-card:hover { transform: translateY(-5px); box-shadow: 0 10px 25px rgba(0,0,0,0.1); }
    .staff-avatar { width: 80px; height: 80px; margin: 0 auto 1rem; position: relative; }
    .staff-avatar img, .staff-avatar .placeholder { width: 100%; height: 100%; border-radius: 50%; object-fit: cover; }
    .staff-avatar .placeholder { background: var(--pico-primary); color: white; display: flex; align-items: center; justify-content: center; font-size: 2rem; font-weight: bold; }
    .online-indicator { position: absolute; bottom: 5px; right: 5px; width: 15px; height: 15px; border-radius: 50%; border: 3px solid var(--pico-card-background-color); }
    .staff-name { text-decoration: none; color: inherit; transition: color 0.2s; }
    .staff-name:hover { color: var(--pico-primary); }
</style>

<hgroup>
    <h2><i class="fa-solid fa-shield-halved" style="color: #e74c3c;"></i> Команда проекта</h2>
    <p>Официальные представители и модераторы LaiCMS</p>
</hgroup>

<div class="grid">
    <?php while($s = $staff->fetch_assoc()): 
        $is_online = (strtotime($s['last_seen'] ?? '') > time() - 300);
        $letter = mb_strtoupper(mb_substr($s['username'], 0, 1));
        $role_label = ($s['role'] === 'admin') ? 'Администратор' : 'Модератор';
        $role_color = ($s['role'] === 'admin') ? '#e74c3c' : '#f1c40f';
    ?>
    <article class="staff-card" style="text-align: center;">
        <div class="staff-avatar">
            <?php if(!empty($s['avatar'])): ?>
                <img src="<?= $s['avatar'] ?>" alt="Avatar">
            <?php else: ?>
                <div class="placeholder" style="background: <?= $role_color ?>;"><?= $letter ?></div>
            <?php endif; ?>
            <div class="online-indicator" style="background: <?= $is_online ? '#2ecc71' : '#95a5a6' ?>;"></div>
        </div>

        <a href="account.php?id=<?= $s['id'] ?>" class="staff-name">
            <h4 style="margin-bottom: 0.5rem;"><?= _e($s['username']) ?></h4>
        </a>
        
        <p>
            <mark style="background: <?= $role_color ?>; color: <?= ($s['role'] === 'mod') ? '#000' : '#fff' ?>; padding: 2px 12px; border-radius: 20px; font-size: 0.8rem;">
                <?= $role_label ?>
            </mark>
        </p>

        <footer style="background: transparent; border: none; padding-top: 0;">
            <div class="grid">
                <a href="account.php?id=<?= $s['id'] ?>" class="outline" role="button" style="font-size: 0.8rem; padding: 5px;">Профиль</a>
                <a href="#" class="outline secondary" role="button" style="font-size: 0.8rem; padding: 5px;">ЛС</a>
            </div>
        </footer>
    </article>
    <?php endwhile; ?>
</div>

<div style="text-align: center; margin-top: 3rem;">
    <a href="/index.php" class="secondary" style="text-decoration: none;">
        <i class="fa-solid fa-house"></i> На главную страницу
    </a>
</div>

<?php include '../system/footer.php'; ?>

