<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: users/register.php
 * Description: Регистрация с визуализацией процесса создания аккаунта.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (isset($_SESSION['user_id'])) {
    header("Location: /index.php");
    exit;
}

$registration_success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !check_csrf($_POST['csrf_token'])) {
        die("Security Token Invalid");
    }

    if (!empty($_POST['website_url'])) die("Bot detected.");

    $user = trim($_POST['username']);
    $pass = $_POST['password'];
    $pass_confirm = $_POST['password_confirm'];
    $ip = $_SERVER['REMOTE_ADDR'];
    $ua = $_SERVER['HTTP_USER_AGENT'];

    if (strlen($user) < 3 || !preg_match('/^[a-zA-Z0-9_]+$/', $user)) {
        set_flash("Логин от 3 символов (латиница/цифры)", "error");
    } elseif ($pass !== $pass_confirm) {
        set_flash("Пароли не совпадают", "error");
    } elseif (strlen($pass) < 6) {
        set_flash("Пароль слишком слабый", "error");
    } else {
        $check = $mysqli->prepare("SELECT id FROM users WHERE username = ? LIMIT 1");
        $check->bind_param("s", $user);
        $check->execute();
        
        if ($check->get_result()->num_rows > 0) {
            set_flash("Имя пользователя уже занято", "error");
        } else {
            $hash = password_hash($pass, PASSWORD_DEFAULT);
            $stmt = $mysqli->prepare("INSERT INTO users (username, password, role, last_ip, last_ua) VALUES (?, ?, 'user', ?, ?)");
            $stmt->bind_param("ssss", $user, $hash, $ip, $ua);
            
            if ($stmt->execute()) {
                if (function_exists('write_log')) write_log("Регистрация: $user", "success");
                $registration_success = true;
            } else {
                set_flash("Ошибка БД. Попробуйте позже.", "error");
            }
        }
    }
}

include '../system/header.php';
?>

<style>
    /* Анимационный экран успеха */
    #reg-overlay {
        display: none;
        position: fixed;
        top: 0; left: 0; width: 100%; height: 100%;
        background: rgba(0, 0, 0, 0.85);
        backdrop-filter: blur(15px);
        -webkit-backdrop-filter: blur(15px);
        z-index: 10000;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        color: white;
    }
    .dna-loader {
        width: 60px; height: 60px;
        border: 4px double var(--pico-primary);
        border-radius: 50%;
        border-top-style: solid;
        animation: rotate 2s linear infinite;
        margin-bottom: 20px;
    }
    @keyframes rotate { to { transform: rotate(360deg); } }

    .reg-card {
        max-width: 500px;
        margin: 2rem auto;
        border-radius: 24px;
        background: var(--pico-card-background-color);
        box-shadow: 0 30px 60px rgba(0,0,0,0.12);
        overflow: hidden;
    }
    .strength-meter {
        height: 4px; width: 0%;
        background: #e74c3c;
        transition: 0.4s;
        margin-top: 5px;
        border-radius: 2px;
    }
</style>

<div id="reg-overlay">
    <div class="dna-loader"></div>
    <h2 id="status-title">Инициализация...</h2>
    <p id="status-sub" class="secondary">Создаем ваш цифровой отпечаток</p>
</div>

<article class="reg-card">
    <header style="text-align: center; background: linear-gradient(to bottom, var(--pico-primary-background), transparent); padding: 2rem 1rem; border: none;">
        <i class="fa-solid fa-user-astronaut fa-3x" style="color: var(--pico-primary); margin-bottom: 1rem;"></i>
        <h3>Новый профиль</h3>
        <p class="secondary" style="font-size: 0.85rem;">Присоединяйтесь к экосистеме LaiCMS</p>
    </header>

    <?php display_flash(); ?>

    <form method="POST" id="regForm">
        <input type="hidden" name="csrf_token" value="<?= _e($_SESSION['csrf_token']) ?>">
        
        <div style="display:none;"><input type="text" name="website_url"></div>

        <label for="username">Логин</label>
        <input type="text" id="username" name="username" placeholder="Придумайте имя" required>

        <div class="grid">
            <div>
                <label for="password">Пароль</label>
                <input type="password" id="password" name="password" placeholder="••••••••" required oninput="checkStrength(this.value)">
                <div class="strength-meter" id="meter"></div>
            </div>
            <div>
                <label for="password_confirm">Подтверждение</label>
                <input type="password" id="password_confirm" name="password_confirm" placeholder="••••••••" required>
            </div>
        </div>

        <button type="submit" class="primary" style="margin-top: 2rem; width: 100%;">
            Создать аккаунт
        </button>
    </form>

    <footer style="text-align: center; border: none; background: transparent;">
        <small>Уже в системе? <a href="login.php">Войти в терминал</a></small>
    </footer>
</article>

<script>
function checkStrength(p) {
    let m = document.getElementById('meter');
    let s = 0;
    if(p.length > 5) s += 25;
    if(/[A-Z]/.test(p)) s += 25;
    if(/[0-9]/.test(p)) s += 25;
    if(/[^A-Za-z0-9]/.test(p)) s += 25;
    m.style.width = s + "%";
    m.style.background = s < 50 ? "#e74c3c" : (s < 100 ? "#f1c40f" : "#2ecc71");
}

<?php if ($registration_success): ?>
    const overlay = document.getElementById('reg-overlay');
    const title = document.getElementById('status-title');
    const sub = document.getElementById('status-sub');
    
    overlay.style.display = 'flex';
    
    setTimeout(() => {
        title.innerText = "Аккаунт создан!";
        sub.innerText = "Синхронизация данных завершена успешно.";
    }, 1000);

    setTimeout(() => {
        window.location.href = "login.php?msg=registered";
    }, 2500);
<?php endif; ?>
</script>

<?php include '../system/footer.php'; ?>

