<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: users/profile.php
 * Особенности: Интеграция с блогом, кошелек (LaiCoins), обрезка фото Cropper.js.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = (int)$_SESSION['user_id'];

// --- ОБРАБОТКА ДАННЫХ ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!check_csrf($_POST['csrf_token'])) die("Security violation.");

    // 1. Смена пароля
    if (isset($_POST['change_password'])) {
        $new_pass = $_POST['new_password'];
        if (strlen($new_pass) < 6) {
            set_flash("Пароль слишком короткий", "error");
        } else {
            $hash = password_hash($new_pass, PASSWORD_DEFAULT);
            $mysqli->query("UPDATE users SET password = '$hash' WHERE id = $user_id");
            set_flash("Пароль обновлен", "success");
        }
    }

    // 2. Личные данные
    if (isset($_POST['update_meta'])) {
        $gender = in_array($_POST['gender'], ['male', 'female']) ? $_POST['gender'] : 'not_set';
        $bio = mb_strimwidth(strip_tags($_POST['bio']), 0, 500);
        
        $stmt = $mysqli->prepare("UPDATE users SET gender = ?, bio = ? WHERE id = ?");
        $stmt->bind_param("ssi", $gender, $bio, $user_id);
        $stmt->execute();
        set_flash("Профиль обновлен", "success");
    }

    // 3. Загрузка аватара (Base64)
    if (!empty($_POST['avatar_base64'])) {
        $data = $_POST['avatar_base64'];
        if (preg_match('/^data:image\/(\w+);base64,/', $data, $type)) {
            $data = base64_decode(substr($data, strpos($data, ',') + 1));
            $upload_dir = '../uploads/avatars/';
            if (!is_dir($upload_dir)) mkdir($upload_dir, 0755, true);
            $filename = md5((string)$user_id) . '_' . time() . '.png';
            file_put_contents($upload_dir . $filename, $data);
            $db_path = '/uploads/avatars/' . $filename;
            $mysqli->query("UPDATE users SET avatar = '$db_path' WHERE id = $user_id");
            set_flash("Аватар обновлен!", "success");
        }
    }
    
    header("Location: profile.php");
    exit;
}

// Получаем полные данные пользователя (включая баланс)
$user = $mysqli->query("SELECT * FROM users WHERE id = $user_id")->fetch_assoc();

// СТАТИСТИКА БЛОГА
$count_posts = $mysqli->query("SELECT COUNT(*) as total FROM posts WHERE author_id = $user_id")->fetch_assoc()['total'];
$count_comments = $mysqli->query("SELECT COUNT(*) as total FROM comments WHERE user_id = $user_id")->fetch_assoc()['total'];

$page_title = "Мой профиль — LaiCMS";
include '../system/header.php';
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.6.1/cropper.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.6.1/cropper.min.js"></script>

<style>
    .avatar-wrapper { position: relative; width: 150px; height: 150px; margin: 0 auto 1.5rem; cursor: pointer; }
    .avatar-img { width: 100%; height: 100%; object-fit: cover; border-radius: 50%; border: 4px solid var(--pico-primary); transition: 0.3s; }
    .avatar-wrapper:hover .avatar-img { filter: brightness(0.8); }
    .avatar-placeholder { width: 100%; height: 100%; background: var(--pico-primary); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 4rem; }
    
    .blog-stat-card { text-align: center; padding: 1rem; background: var(--pico-card-sectioning-background-color); border-radius: 12px; border: 1px solid var(--pico-muted-border-color); }
    
    /* Стили кошелька */
    .wallet-section { 
        background: linear-gradient(135deg, rgba(79, 70, 229, 0.1) 0%, rgba(16, 149, 193, 0.1) 100%); 
        padding: 1.5rem; border-radius: 16px; border: 1px solid rgba(79, 70, 229, 0.2); margin-bottom: 1rem;
    }
    .balance-amount { font-size: 1.8rem; font-weight: 800; color: var(--pico-primary); display: block; line-height: 1; margin: 5px 0; }
    
    #crop-modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); align-items: center; justify-content: center; }
</style>

<hgroup>
    <h2><i class="fa-solid fa-circle-user"></i> Личный кабинет</h2>
    <p>Добро пожаловать, <?= _e($user['username']) ?></p>
</hgroup>

<div class="grid">
    <aside>
        <article style="text-align: center;">
            <div class="avatar-wrapper" onclick="document.getElementById('fileInput').click()" title="Нажмите, чтобы изменить">
                <?php if($user['avatar']): ?>
                    <img src="<?= $user['avatar'] ?>" class="avatar-img">
                <?php else: ?>
                    <div class="avatar-placeholder"><?= mb_strtoupper(mb_substr($user['username'], 0, 1)) ?></div>
                <?php endif; ?>
                <div style="position: absolute; bottom: 5px; right: 5px; background: var(--pico-primary); color: white; width: 35px; height: 35px; border-radius: 50%; display: flex; align-items: center; justify-content: center; border: 3px solid var(--pico-card-background-color);">
                    <i class="fa-solid fa-camera" style="font-size: 0.8rem;"></i>
                </div>
            </div>
            <input type="file" id="fileInput" accept="image/*" style="display:none">
            
            <div class="wallet-section">
                <small class="secondary" style="text-transform: uppercase; letter-spacing: 1px; font-weight: bold;">Ваш баланс</small>
                <span class="balance-amount"><?= number_format($user['balance'], 0, '.', ' ') ?> <small style="font-size: 0.9rem;">LC</small></span>
                <a href="/shop/deposit.php" role="button" class="primary shadow" style="width: 100%; font-size: 0.8rem; padding: 8px; border-radius: 50px; margin-top: 10px;">
                    <i class="fa-solid fa-circle-plus"></i> Пополнить баланс
                </a>
            </div>

            <div style="text-align: left;">
                <label style="margin-bottom: 0.5rem;"><i class="fa-solid fa-chart-pie"></i> Статистика:</label>
                <div class="grid" style="margin-bottom: 1rem; gap: 10px;">
                    <div class="blog-stat-card">
                        <small class="secondary">Посты</small><br><strong><?= $count_posts ?></strong>
                    </div>
                    <div class="blog-stat-card">
                        <small class="secondary">Ответы</small><br><strong><?= $count_comments ?></strong>
                    </div>
                </div>
                
                <a href="/blog/my_posts.php" class="secondary outline" style="width: 100%; margin-bottom: 10px; display: block; text-align: center; text-decoration: none; padding: 10px; border-radius: 12px; font-size: 0.9rem;">
                    <i class="fa-solid fa-rectangle-list"></i> Мои публикации
                </a>
                <a href="/blog/add_post.php" class="contrast" style="width: 100%; display: block; text-align: center; text-decoration: none; padding: 10px; border-radius: 12px; font-size: 0.9rem; background: var(--pico-primary); color: white;">
                    <i class="fa-solid fa-pen-nib"></i> Создать пост
                </a>
            </div>
        </article>
    </aside>

    <div style="flex: 2;">
        <article class="animate__animated animate__fadeIn">
            <header><strong><i class="fa-solid fa-address-card"></i> Персональные данные</strong></header>
            <form method="POST">
                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                
                <div class="grid">
                    <label for="gender">Ваш пол
                        <select id="gender" name="gender">
                            <option value="not_set" <?= $user['gender'] == 'not_set' ? 'selected' : '' ?>>Не указан</option>
                            <option value="male" <?= $user['gender'] == 'male' ? 'selected' : '' ?>>Мужской</option>
                            <option value="female" <?= $user['gender'] == 'female' ? 'selected' : '' ?>>Женский</option>
                        </select>
                    </label>
                    <label>Дата регистрации
                        <input type="text" value="<?= date('d.m.Y', strtotime($user['created_at'] ?? 'now')) ?>" disabled>
                    </label>
                </div>

                <label for="bio">О себе (публичная информация)</label>
                <textarea id="bio" name="bio" rows="3" placeholder="Расскажите о себе..."><?= _e($user['bio']) ?></textarea>
                
                <button type="submit" name="update_meta" class="primary">Обновить профиль</button>
            </form>
        </article>

        <article>
            <header><strong><i class="fa-solid fa-shield-halved"></i> Безопасность аккаунта</strong></header>
            <form method="POST">
                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                <div class="grid" style="align-items: end;">
                    <label>Смена пароля
                        <input type="password" name="new_password" placeholder="Минимум 6 символов" required>
                    </label>
                    <button type="submit" name="change_password" class="secondary outline" style="margin-bottom: var(--pico-spacing);">Обновить пароль</button>
                </div>
            </form>
        </article>
    </div>
</div>

<div id="crop-modal">
    <article style="max-width: 500px; width: 95%; border-radius: 20px;">
        <header>
            <h4 style="margin:0;">Корректировка аватара</h4>
        </header>
        <div style="max-height: 400px; overflow: hidden; background: #000;">
            <img id="crop-image" style="max-width: 100%;">
        </div>
        <footer style="display: flex; gap: 10px; justify-content: flex-end; padding-top: 1rem;">
            <button class="secondary outline" onclick="closeCrop()" style="margin:0;">Отмена</button>
            <button onclick="saveCrop()" style="margin:0;">Сохранить фото</button>
        </footer>
    </article>
</div>

<form id="avatarSubmitForm" method="POST">
    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
    <input type="hidden" name="avatar_base64" id="avatar_base64">
</form>

<script>
    let cropper;
    const fileInput = document.getElementById('fileInput');
    const cropModal = document.getElementById('crop-modal');
    const cropImg = document.getElementById('crop-image');

    fileInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(event) {
                cropImg.src = event.target.result;
                cropModal.style.display = 'flex';
                if(cropper) cropper.destroy();
                cropper = new Cropper(cropImg, { 
                    aspectRatio: 1, 
                    viewMode: 1,
                    dragMode: 'move',
                    guides: false,
                    autoCropArea: 1
                });
            };
            reader.readAsDataURL(file);
        }
    });

    function saveCrop() {
        const canvas = cropper.getCroppedCanvas({ width: 300, height: 300 });
        document.getElementById('avatar_base64').value = canvas.toDataURL('image/png');
        document.getElementById('avatarSubmitForm').submit();
    }

    function closeCrop() { cropModal.style.display = 'none'; fileInput.value = ''; }
</script>

<?php include '../system/footer.php'; ?>

