<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: users/online.php
 * Description: Интерактивный список пользователей онлайн с расширенной аналитикой для админа.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /users/login.php");
    exit;
}

$page_title = "Кто онлайн — LaiCMS";
include '../system/header.php';

// Запрос активных пользователей
$query = "SELECT id, username, last_ip, last_ua, last_seen, role, avatar FROM users WHERE last_seen > NOW() - INTERVAL 5 MINUTE ORDER BY last_seen DESC";
$result = $mysqli->query($query);
$count = $result->num_rows;
$is_admin = isAdmin();
?>

<style>
    .online-card {
        border-radius: 16px;
        transition: all 0.3s ease;
        border: 1px solid var(--pico-muted-border-color);
        background: var(--pico-card-background-color);
        margin-bottom: 1rem;
    }
    
    .online-card:hover {
        border-color: #2ecc71;
        box-shadow: 0 8px 20px rgba(46, 204, 113, 0.1);
    }

    .user-flex {
        display: flex;
        align-items: center;
        gap: 15px;
        padding: 1rem;
    }

    .avatar-status {
        position: relative;
        width: 50px;
        height: 50px;
    }

    .avatar-img {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        object-fit: cover;
    }

    .pulse-online {
        position: absolute;
        bottom: 2px;
        right: 2px;
        width: 12px;
        height: 12px;
        background: #2ecc71;
        border: 2px solid var(--pico-card-background-color);
        border-radius: 50%;
        box-shadow: 0 0 8px #2ecc71;
    }

    .admin-meta {
        background: var(--pico-card-sectioning-background-color);
        padding: 0.5rem 1rem;
        border-top: 1px solid var(--pico-muted-border-color);
        font-family: 'Courier New', monospace;
        font-size: 0.75rem;
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
    }

    .role-badge-small {
        font-size: 0.6rem;
        padding: 2px 8px;
        border-radius: 20px;
        font-weight: bold;
        text-transform: uppercase;
        background: var(--pico-primary-background);
        color: var(--pico-primary);
    }

    @media (max-width: 600px) {
        .admin-meta { flex-direction: column; gap: 5px; }
    }
</style>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <hgroup style="margin: 0;">
        <h2><i class="fa-solid fa-satellite-dish" style="color: #2ecc71;"></i> Эфир LaiCMS</h2>
        <p>Сейчас на связи: <strong><?= $count ?></strong></p>
    </hgroup>
    <a href="/users/index.php" class="outline secondary" role="button" style="font-size: 0.8rem;">Все жители</a>
</div>

<div class="online-list">
    <?php if($count > 0): ?>
        <?php while($u = $result->fetch_assoc()): 
            $letter = mb_strtoupper(mb_substr($u['username'], 0, 1));
        ?>
            <div class="online-card">
                <div class="user-flex">
                    <div class="avatar-status">
                        <?php if(!empty($u['avatar'])): ?>
                            <img src="<?= $u['avatar'] ?>" class="avatar-img">
                        <?php else: ?>
                            <div class="avatar-img" style="background: var(--pico-primary); color: white; display: flex; align-items: center; justify-content: center; font-weight: bold;">
                                <?= $letter ?>
                            </div>
                        <?php endif; ?>
                        <div class="pulse-online"></div>
                    </div>
                    
                    <div style="flex-grow: 1;">
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <a href="/users/account.php?id=<?= $u['id'] ?>" style="text-decoration: none; color: inherit;">
                                <h5 style="margin:0;"><?= _e($u['username']) ?></h5>
                            </a>
                            <span class="role-badge-small"><?= $u['role'] ?></span>
                        </div>
                        <small class="secondary"><i class="fa-regular fa-clock"></i> Активен в <?= date('H:i:s', strtotime($u['last_seen'])) ?></small>
                    </div>

                    <div>
                        <a href="/messages/compose.php?to_id=<?= $u['id'] ?>" class="outline" role="button" style="padding: 5px 15px; font-size: 0.75rem; border-radius: 50px;">
                            <i class="fa-solid fa-paper-plane"></i>
                        </a>
                    </div>
                </div>

                <?php if ($is_admin): ?>
                    <div class="admin-meta">
                        <span><i class="fa-solid fa-network-wired"></i> IP: <code><?= $u['last_ip'] ?></code></span>
                        <span title="<?= _e($u['last_ua']) ?>"><i class="fa-solid fa-laptop-code"></i> UA: <?= _e(mb_strimwidth($u['last_ua'], 0, 40, "...")) ?></span>
                    </div>
                <?php endif; ?>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <article style="text-align: center; padding: 3rem;">
            <i class="fa-solid fa-ghost" style="font-size: 3rem; opacity: 0.2; display: block; margin-bottom: 1rem;"></i>
            <p class="secondary">Похоже, все ушли пить кофе...</p>
        </article>
    <?php endif; ?>
</div>

<footer style="margin-top: 3rem; text-align: center; opacity: 0.7;">
    <small>
        <i class="fa-solid fa-circle-check" style="color: #2ecc71;"></i> Данные обновляются автоматически при каждом действии.
    </small>
</footer>

<?php include '../system/footer.php'; ?>

