<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: users/logout.php
 * Description: Безопасный выход из системы с визуальным подтверждением.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

// Сохраняем имя для прощания, прежде чем убить сессию
$username = $_SESSION['username'] ?? 'Гость';

// 1. Очищаем массив сессии
$_SESSION = [];

// 2. Удаляем куки сессии
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// 3. Уничтожаем сессию на сервере
session_destroy();

include '../system/header.php';
?>

<style>
    #logout-screen {
        position: fixed;
        top: 0; left: 0; width: 100%; height: 100%;
        background: var(--pico-background-color);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        z-index: 9999;
        text-align: center;
        animation: fadeIn 0.5s ease-out;
    }

    .logout-box {
        padding: 2rem;
        max-width: 400px;
    }

    .shutter-icon {
        font-size: 3rem;
        color: var(--pico-primary);
        margin-bottom: 1.5rem;
        filter: drop-shadow(0 0 10px rgba(16, 149, 193, 0.3));
    }

    .progress-bar {
        width: 100%;
        height: 4px;
        background: var(--pico-muted-border-color);
        border-radius: 10px;
        margin-top: 2rem;
        overflow: hidden;
    }

    .progress-fill {
        width: 0%;
        height: 100%;
        background: var(--pico-primary);
        transition: width 1.5s linear;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
</style>

<div id="logout-screen">
    <div class="logout-box">
        <div class="shutter-icon">
            <i class="fa-solid fa-power-off"></i>
        </div>
        <h2 style="margin-bottom: 0.5rem;">До встречи, <?= _e($username) ?>!</h2>
        <p class="secondary">Завершаем безопасное соединение...</p>
        
        <div class="progress-bar">
            <div class="progress-fill" id="p-fill"></div>
        </div>
    </div>
</div>

<script>
    // Инициализируем полосу прогресса
    setTimeout(() => {
        document.getElementById('p-fill').style.width = '100%';
    }, 100);

    // Редирект после завершения анимации
    setTimeout(() => {
        window.location.href = "/index.php";
    }, 1600);
</script>

<?php include '../system/footer.php'; ?>

