<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: users/login.php
 * Description: Авторизация с защитой Brute-force и футуристичным уведомлением.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

// 1. ЗАЩИТА ОТ ПЕРЕБОРА
if (!isset($_SESSION['login_attempts'])) $_SESSION['login_attempts'] = 0;
if ($_SESSION['login_attempts'] >= 5 && (time() - ($_SESSION['last_attempt_time'] ?? 0)) < 300) {
    die("Доступ временно ограничен на 5 минут из-за частых попыток.");
}

$show_success_anim = false;

// 2. ОБРАБОТКА ВХОДА
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !check_csrf($_POST['csrf_token'])) {
        set_flash("Ошибка безопасности.", "error");
    } else {
        $user_input = trim($_POST['username']);
        $pass_input = $_POST['password'];

        $stmt = $mysqli->prepare("SELECT id, username, password, role FROM users WHERE username = ? LIMIT 1");
        $stmt->bind_param("s", $user_input);
        $stmt->execute();
        $u = $stmt->get_result()->fetch_assoc();

        if ($u && password_verify($pass_input, $u['password'])) {
            // Обновление метрик
            $ip = $_SERVER['REMOTE_ADDR'];
            $ua = $_SERVER['HTTP_USER_AGENT'];
            $user_id = (int)$u['id'];

            $update = $mysqli->prepare("UPDATE users SET last_ip = ?, last_ua = ?, last_seen = NOW() WHERE id = ?");
            $update->bind_param("ssi", $ip, $ua, $user_id);
            $update->execute();

            session_regenerate_id(true);
            $_SESSION['user_id'] = $user_id;
            $_SESSION['username'] = $u['username'];
            $_SESSION['role'] = $u['role'];
            $_SESSION['ua_fingerprint'] = md5($ua);
            
            unset($_SESSION['login_attempts']);
            
            // Флаг для запуска анимации
            $show_success_anim = true;
        } else {
            $_SESSION['login_attempts']++;
            $_SESSION['last_attempt_time'] = time();
            set_flash("Неверный логин или пароль. Попыток: " . (5 - $_SESSION['login_attempts']), "error");
        }
    }
}

include '../system/header.php';
?>

<style>
    /* Футуристичный оверлей успеха */
    #auth-loader {
        display: none;
        position: fixed;
        top: 0; left: 0; width: 100%; height: 100%;
        background: rgba(0, 0, 0, 0.8);
        backdrop-filter: blur(15px);
        -webkit-backdrop-filter: blur(15px);
        z-index: 9999;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        color: white;
        text-align: center;
    }
    .auth-circle {
        width: 80px; height: 80px;
        border: 4px solid var(--pico-primary);
        border-top-color: transparent;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-bottom: 1.5rem;
    }
    @keyframes spin { to { transform: rotate(360deg); } }
    
    .login-card {
        max-width: 420px;
        margin: 3rem auto;
        padding: 2rem;
        border-radius: 20px;
        box-shadow: 0 20px 50px rgba(0,0,0,0.15);
        background: var(--pico-card-background-color);
    }
</style>

<div id="auth-loader">
    <div class="auth-circle"></div>
    <h2 id="welcome-msg" style="opacity: 0; transform: translateY(20px); transition: 0.5s;">
        Авторизация успешна
    </h2>
    <p id="sub-msg" style="opacity: 0; transition: 0.8s;">Готовим ваше рабочее пространство...</p>
</div>

<article class="login-card">
    <header style="text-align: center; border: none; background: transparent;">
        <div style="background: var(--pico-primary); width: 60px; height: 60px; border-radius: 15px; display: flex; align-items: center; justify-content: center; margin: 0 auto 1.5rem; box-shadow: 0 10px 20px rgba(0,0,0,0.2);">
            <i class="fa-solid fa-unlock-keyhole" style="color: white; font-size: 1.5rem;"></i>
        </div>
        <hgroup>
            <h3>Вход в LaiCMS</h3>
            <p class="secondary">Введите данные для доступа</p>
        </hgroup>
    </header>

    <?php display_flash(); ?>

    <form method="POST">
        <input type="hidden" name="csrf_token" value="<?= _e($_SESSION['csrf_token'] ?? '') ?>">
        
        <label for="username">Логин</label>
        <input type="text" id="username" name="username" 
               placeholder="username" 
               value="<?= isset($_POST['username']) ? _e($_POST['username']) : '' ?>" required>
        
        <label for="password">Пароль</label>
        <input type="password" id="password" name="password" placeholder="••••••••" required>
        
        <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 1rem;">
            <label style="margin: 0; font-size: 0.9rem;">
                <input type="checkbox" name="remember"> Запомнить
            </label>
            <a href="#" class="secondary" style="font-size: 0.85rem;">Забыли пароль?</a>
        </div>

        <button type="submit" class="primary" style="margin-top: 1.5rem; width: 100%;">
            Авторизоваться
        </button>
    </form>
    
    <footer style="text-align: center; padding-top: 1rem;">
        <small>Еще нет аккаунта? <a href="register.php">Создать профиль</a></small>
    </footer>
</article>

<script>
<?php if ($show_success_anim): ?>
    // Запуск современной анимации после POST запроса
    const loader = document.getElementById('auth-loader');
    const msg = document.getElementById('welcome-msg');
    const sub = document.getElementById('sub-msg');

    loader.style.display = 'flex';
    
    setTimeout(() => {
        msg.style.opacity = '1';
        msg.style.transform = 'translateY(0)';
        msg.innerText = "С возвращением, <?= _e($_SESSION['username']) ?>!";
    }, 200);

    setTimeout(() => {
        sub.style.opacity = '0.7';
    }, 600);

    // Редирект через 1.8 секунды для эффекта загрузки
    setTimeout(() => {
        window.location.href = "/index.php";
    }, 1800);
<?php endif; ?>
</script>

<?php include '../system/footer.php'; ?>

