<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: users/index.php
 * Description: Тотальное обновление списка участников. Адаптивный Grid + Glassmorphism.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /users/login.php");
    exit;
}

$page_title = "Участники сообщества — LaiCMS";
include '../system/header.php';

// Получаем пользователей
$users = $mysqli->query("SELECT id, username, role, last_seen, avatar FROM users ORDER BY last_seen DESC");
?>

<style>
    :root {
        --user-card-shadow: 0 10px 20px rgba(0,0,0,0.05);
    }

    .users-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 1.5rem;
        margin-top: 2rem;
    }

    .user-card {
        position: relative;
        overflow: hidden;
        border-radius: 20px;
        border: 1px solid var(--pico-muted-border-color);
        background: var(--pico-card-background-color);
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 2rem 1.5rem;
    }

    .user-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.15);
        border-color: var(--pico-primary);
    }

    /* Аватары */
    .avatar-wrapper {
        position: relative;
        margin-bottom: 1.2rem;
    }

    .avatar-large {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid var(--pico-primary);
        padding: 3px;
        background: var(--pico-card-background-color);
    }

    .avatar-placeholder {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        background: linear-gradient(45deg, var(--pico-primary), #9b59b6);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        font-weight: bold;
    }

    /* Статус онлайн */
    .status-indicator {
        position: absolute;
        bottom: 5px;
        right: 5px;
        width: 18px;
        height: 18px;
        border-radius: 50%;
        border: 3px solid var(--pico-card-background-color);
    }
    .online { background: #2ecc71; box-shadow: 0 0 10px #2ecc71; }
    .offline { background: #95a5a6; }

    /* Бейджи */
    .role-tag {
        font-size: 0.7rem;
        font-weight: 800;
        text-transform: uppercase;
        padding: 4px 12px;
        border-radius: 50px;
        margin-bottom: 0.5rem;
        letter-spacing: 0.5px;
    }

    .btn-profile {
        width: 100%;
        margin-top: 1.5rem;
        border-radius: 12px;
        font-size: 0.9rem;
    }

    /* Адаптив для мобилок */
    @media (max-width: 600px) {
        .users-grid {
            grid-template-columns: 1fr;
            gap: 1rem;
        }
        .user-card {
            flex-direction: row;
            padding: 1rem;
            text-align: left;
            align-items: center;
        }
        .avatar-large, .avatar-placeholder {
            width: 60px;
            height: 60px;
            font-size: 1.2rem;
        }
        .user-info-mob {
            margin-left: 1rem;
            flex-grow: 1;
        }
        .btn-profile {
            width: auto;
            margin-top: 0;
            padding: 5px 15px;
        }
        .avatar-wrapper { margin-bottom: 0; }
    }
</style>

<header style="text-align: center; margin-bottom: 3rem;">
    <hgroup>
        <h1 style="font-size: 2.5rem; margin-bottom: 0.5rem;">Сообщество</h1>
        <p class="secondary">Познакомьтесь с теми, кто создает историю LaiCMS</p>
    </hgroup>
</header>

<div class="users-grid">
    <?php while($u = $users->fetch_assoc()): 
        $is_online = (strtotime($u['last_seen'] ?? '') > time() - 300);
        $letter = mb_strtoupper(mb_substr($u['username'], 0, 1));
        
        // Стилизация ролей
        $role_style = ($u['role'] === 'admin') ? 'background: rgba(231, 76, 60, 0.1); color: #e74c3c;' : 'background: rgba(16, 149, 193, 0.1); color: var(--pico-primary);';
    ?>
    
    <div class="user-card">
        <div class="avatar-wrapper">
            <?php if(!empty($u['avatar'])): ?>
                <img src="<?= $u['avatar'] ?>" class="avatar-large" alt="Avatar">
            <?php else: ?>
                <div class="avatar-placeholder"><?= $letter ?></div>
            <?php endif; ?>
            <div class="status-indicator <?= $is_online ? 'online' : 'offline' ?>"></div>
        </div>

        <div class="user-info-mob">
            <div style="text-align: inherit;">
                <span class="role-tag" style="<?= $role_style ?>">
                    <?= _e($u['role']) ?>
                </span>
                <h4 style="margin: 0; font-size: 1.2rem;"><?= _e($u['username']) ?></h4>
                <small class="secondary">
                    <?= $is_online ? '<span style="color:#2ecc71">В сети сейчас</span>' : 'Был ' . date('d.m.y H:i', strtotime($u['last_seen'])) ?>
                </small>
            </div>
        </div>

        <a href="account.php?id=<?= $u['id'] ?>" class="button outline btn-profile">Профиль</a>
    </div>
    
    <?php endwhile; ?>
</div>

<footer style="margin-top: 4rem; text-align: center; opacity: 0.6;">
    <p><i class="fa-solid fa-shield-halved"></i> Данные участников защищены протоколом LaiCMS 2026</p>
</footer>

<?php include '../system/footer.php'; ?>

