<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: users/account.php
 * Description: Прогрессивный профиль с блоком последних постов пользователя.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isset($_GET['id'])) {
    header("Location: /index.php");
    exit;
}

$target_id = (int)$_GET['id'];
$stmt = $mysqli->prepare("SELECT * FROM users WHERE id = ? LIMIT 1");
$stmt->bind_param("i", $target_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

if (!$user) {
    include '../system/header.php';
    echo "<article class='container' style='text-align:center; padding: 5rem 0;'><h3 style='color:var(--pico-primary);'>Объект не найден в базе данных</h3><a href='/index.php' role='button' class='outline'>Вернуться на главную</a></article>";
    include '../system/footer.php';
    exit;
}

// Запрос последних постов пользователя с категориями
$posts_stmt = $mysqli->prepare("
    SELECT p.id, p.title, p.slug, p.created_at, c.name as cat_name 
    FROM posts p 
    LEFT JOIN categories c ON p.category_id = c.id 
    WHERE p.author_id = ? 
    ORDER BY p.created_at DESC 
    LIMIT 5
");
$posts_stmt->bind_param("i", $target_id);
$posts_stmt->execute();
$user_posts = $posts_stmt->get_result();

$is_online = (strtotime($user['last_seen'] ?? '') > time() - 300);
$first_letter = mb_strtoupper(mb_substr($user['username'], 0, 1));
$page_title = "Профиль " . _e($user['username']) . " — LaiCMS";

include '../system/header.php';
?>

<style>
    /* Динамический фон профиля */
    .profile-header-bg {
        height: 120px;
        background: linear-gradient(135deg, var(--pico-primary) 0%, #6f42c1 100%);
        border-radius: 20px 20px 0 0;
        margin-bottom: -60px;
    }
    .profile-sidebar { text-align: center; padding: 0; overflow: hidden; border-radius: 20px; box-shadow: 0 15px 35px rgba(0,0,0,0.1); }
    .avatar-container { position: relative; display: inline-block; margin-top: 20px; }
    .avatar-big { width: 140px; height: 140px; border-radius: 50%; object-fit: cover; border: 6px solid var(--pico-card-background-color); background: var(--pico-card-background-color); box-shadow: 0 5px 15px rgba(0,0,0,0.08); }
    .status-ring { position: absolute; bottom: 8px; right: 8px; width: 24px; height: 24px; border-radius: 50%; border: 4px solid var(--pico-card-background-color); }
    .online-glow { background: #2ecc71; box-shadow: 0 0 12px #2ecc71; }
    .offline-glow { background: #95a5a6; }
    .user-name-title { margin: 1rem 0 0.2rem; font-weight: 800; letter-spacing: -0.5px; }
    .role-pill { display: inline-block; padding: 2px 14px; border-radius: 50px; font-size: 0.7rem; font-weight: 700; text-transform: uppercase; background: rgba(16, 149, 193, 0.1); color: var(--pico-primary); }
    .info-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin-top: 1.5rem; }
    .info-tile { background: var(--pico-card-sectioning-background-color); padding: 1rem; border-radius: 12px; border: 1px solid transparent; transition: 0.3s; }
    .info-tile:hover { border-color: var(--pico-primary); }

    /* Стили для блока блогов */
    .user-post-item { 
        display: flex; justify-content: space-between; align-items: center;
        padding: 12px; border-bottom: 1px solid var(--pico-muted-border-color);
        transition: background 0.2s;
    }
    .user-post-item:last-child { border-bottom: none; }
    .user-post-item:hover { background: var(--pico-card-sectioning-background-color); }
    .cat-badge-mini { font-size: 0.65rem; padding: 2px 8px; background: var(--pico-primary); color: white; border-radius: 4px; }

    .admin-terminal { margin-top: 2rem; background: #1a1a1a; color: #00ff41; font-family: 'Courier New', monospace; padding: 1.5rem; border-radius: 12px; border-left: 4px solid #e74c3c; }
    .admin-terminal h5 { color: #e74c3c; margin-bottom: 1rem; border-bottom: 1px solid #333; padding-bottom: 0.5rem; }
    .admin-btn { font-size: 0.75rem !important; border-radius: 8px !important; }

    @media (max-width: 992px) { .grid { grid-template-columns: 1fr; } .profile-sidebar { margin-bottom: 2rem; } }
</style>

<div class="container" style="margin-top: 2rem;">
    <div class="grid">
        <aside>
            <div class="profile-header-bg"></div>
            <article class="profile-sidebar">
                <div class="avatar-container">
                    <?php if($user['avatar']): ?>
                        <img src="<?= $user['avatar'] ?>" class="avatar-big" alt="User Avatar">
                    <?php else: ?>
                        <div class="avatar-big" style="background: var(--pico-primary); color:white; display:flex; align-items:center; justify-content:center; font-size:3.5rem; font-weight:bold;">
                            <?= $first_letter ?>
                        </div>
                    <?php endif; ?>
                    <div class="status-ring <?= $is_online ? 'online-glow' : 'offline-glow' ?>" title="<?= $is_online ? 'В сети' : 'Оффлайн' ?>"></div>
                </div>
                <div style="padding: 0 1.5rem 2rem;">
                    <h3 class="user-name-title"><?= _e($user['username']) ?></h3>
                    <div class="role-pill"><?= _e($user['role']) ?></div>
                    <p class="secondary" style="font-size: 0.85rem; margin: 1rem 0;">На платформе с <?= date('M Y', strtotime($user['created_at'])) ?></p>
                    <?php if(isset($_SESSION['user_id']) && $_SESSION['user_id'] != $user['id']): ?>
                        <a href="/messages/compose.php?to_id=<?= $user['id'] ?>" role="button" class="primary" style="width: 100%; border-radius: 12px;">
                            <i class="fa-solid fa-comment-dots"></i> Сообщение
                        </a>
                    <?php endif; ?>
                </div>
            </article>
        </aside>

        <main>
            <article style="border-radius: 20px;">
                <header style="background: transparent; border-bottom: 1px solid var(--pico-muted-border-color);">
                    <h4 style="margin:0;"><i class="fa-solid fa-address-card" style="color:var(--pico-primary);"></i> Досье пользователя</h4>
                </header>
                <div class="info-grid">
                    <div class="info-tile">
                        <small class="secondary">Гендерный признак</small>
                        <div style="font-weight: 600;">
                            <i class="fa-solid <?= ($user['gender'] ?? '') === 'male' ? 'fa-mars' : (($user['gender'] ?? '') === 'female' ? 'fa-venus' : 'fa-genderless') ?>"></i>
                            <?= ($user['gender'] ?? '') === 'male' ? 'Мужской' : (($user['gender'] ?? '') === 'female' ? 'Женский' : 'Не указан') ?>
                        </div>
                    </div>
                    <div class="info-tile">
                        <small class="secondary">Активность</small>
                        <div style="font-weight: 600;">
                            <i class="fa-solid fa-clock-rotate-left"></i>
                            <?= $is_online ? 'Сейчас онлайн' : 'Был ' . date('d.m H:i', strtotime($user['last_seen'])) ?>
                        </div>
                    </div>
                </div>
                <div style="margin-top: 2rem;">
                    <label style="font-weight: 700; text-transform: uppercase; font-size: 0.75rem; color: var(--pico-primary);">Биография / О себе</label>
                    <div style="padding: 1.5rem; background: var(--pico-card-sectioning-background-color); border-radius: 12px; line-height: 1.6;">
                        <?= !empty($user['bio']) ? nl2br(_e($user['bio'])) : '<span class="secondary italic">Пользователь предпочел оставить это поле пустым.</span>' ?>
                    </div>
                </div>
            </article>

            <article style="border-radius: 20px; margin-top: 2rem;">
                <header style="background: transparent; border-bottom: 1px solid var(--pico-muted-border-color); display: flex; justify-content: space-between; align-items: center;">
                    <h4 style="margin:0;"><i class="fa-solid fa-feather-pointed" style="color:var(--pico-primary);"></i> Публикации автора</h4>
                    <span class="secondary" style="font-size: 0.8rem;">Последние 5 записей</span>
                </header>
                
                <div class="user-posts-list">
                    <?php if($user_posts->num_rows > 0): ?>
                        <?php while($up = $user_posts->fetch_assoc()): ?>
                            <div class="user-post-item">
                                <div>
                                    <a href="/blog/view.php?slug=<?= $up['slug'] ?>" style="text-decoration: none; font-weight: 600;">
                                        <?= _e($up['title']) ?>
                                    </a>
                                    <div style="font-size: 0.75rem;" class="secondary">
                                        <?= date('d.m.Y', strtotime($up['created_at'])) ?>
                                    </div>
                                </div>
                                <?php if($up['cat_name']): ?>
                                    <span class="cat-badge-mini"><?= _e($up['cat_name']) ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <div style="text-align: center; padding: 2rem;" class="secondary">
                            <i class="fa-solid fa-box-open" style="display: block; font-size: 2rem; margin-bottom: 10px;"></i>
                            Автор еще не публиковал статьи.
                        </div>
                    <?php endif; ?>
                </div>
            </article>

            <?php if (isAdmin()): ?>
            <div class="admin-terminal">
                <h5><i class="fa-solid fa-terminal"></i> SYSTEM_DECRYPT_USER_DATA</h5>
                <div class="grid" style="gap: 1rem;">
                    <div><span style="color: #888;">> REMOTE_ADDR:</span><br><span style="color: #fff;"><?= $user['last_ip'] ?? '0.0.0.0' ?></span></div>
                    <div><span style="color: #888;">> SESSION_LAST:</span><br><span style="color: #fff;"><?= !empty($user['last_seen']) ? date('Y-m-d [H:i]', strtotime($user['last_seen'])) : 'NULL' ?></span></div>
                </div>
                <div style="margin: 1rem 0;"><span style="color: #888;">> USER_AGENT_STRING:</span><br><small style="color: #aaa; font-size: 0.75rem;"><?= _e($user['last_ua'] ?? 'SECURE_UNKNOWN') ?></small></div>
                <div style="display: flex; gap: 10px; flex-wrap: wrap; margin-top: 1.5rem;">
                    <a href="/admin/users.php?edit=<?= $user['id'] ?>" role="button" class="admin-btn contrast">УПРАВЛЕНИЕ ПРАВАМИ</a>
                    <a href="/admin/logs.php?user=<?= $user['username'] ?>" role="button" class="admin-btn outline secondary">ПРОСМОТР ЛОГОВ</a>
                </div>
            </div>
            <?php endif; ?>
        </main>
    </div>
</div>

<?php include '../system/footer.php'; ?>

