/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: theme/app.js
 * Description: Логика интерфейса: уведомления, свайпы и работа с формой.
 */

document.addEventListener('DOMContentLoaded', () => {
    
    // 1. Автоматическая очистка уведомлений при клике
    const flashes = document.querySelectorAll('.flash-msg');
    flashes.forEach(msg => {
        msg.style.cursor = 'pointer';
        msg.addEventListener('click', () => {
            msg.style.opacity = '0';
            setTimeout(() => msg.remove(), 300);
        });
    });

    // 2. Индикатор загрузки для всех кнопок форм
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', () => {
            const btn = form.querySelector('button[type="submit"]');
            if (btn) {
                btn.setAttribute('aria-busy', 'true');
                btn.innerText = 'Загрузка...';
            }
        });
    });

    // 3. Сохранение выбранной темы в LocalStorage
    const currentTheme = localStorage.getItem('theme') || 'light';
    document.documentElement.setAttribute('data-theme', currentTheme);
});
