<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: system/header.php
 * Updated: Исправлены отступы иконок, удалены точки, разделен ПК/Мобильный интерфейс.
 */

// 1. ПРОВЕРКА ЦЕЛОСТНОСТИ БД
$check_table = $mysqli->query("SHOW TABLES LIKE 'ads'");
if ($check_table->num_rows == 0) {
    header("Location: /install.php");
    exit;
}

// 2. ЛОГИКА АВТО-ПРОЧТЕНИЯ
if (isset($_SESSION['user_id'])) {
    $current_uid = (int)$_SESSION['user_id'];
    $current_page = basename($_SERVER['PHP_SELF']);
    
    if ($current_page == 'chat.php' && isset($_GET['id'])) {
        $sender_id = (int)$_GET['id'];
        $mysqli->query("UPDATE messages SET is_read = 1 WHERE receiver_id = $current_uid AND sender_id = $sender_id");
    }
}

// 3. ЗАГРУЗКА РЕКЛАМЫ
$top_ad = $mysqli->query("SELECT title, link FROM ads WHERE status = 'active' AND expires_at > NOW() ORDER BY RAND() LIMIT 1")->fetch_assoc();

$page_title = $page_title ?? 'LaiCMS 2026';
?>
<!DOCTYPE html>
<html lang="ru" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($page_title) ?></title>
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@picocss/pico@2/css/pico.indigo.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <script src="https://unpkg.com/htmx.org@1.9.10"></script>
    
    <style>
        :root { 
            --pico-border-radius: 16px;
            --pico-primary: #4f46e5; 
            --ad-gold: #f1c40f;
            --sidebar-width: 290px;
        }

        /* Убираем точки и настраиваем расстояние между иконками */
        nav ul {
            list-style: none !important;
            padding: 0;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 15px; /* Увеличенное расстояние между элементами списка */
        }

        nav li {
            list-style: none !important;
            padding: 0 !important;
            margin: 0 !important;
        }

        .sidebar-menu, .sidebar-menu li {
            list-style: none !important;
        }

        .ad-top-bar {
            background: linear-gradient(90deg, #1a1c2c 0%, #4a192c 100%);
            color: white; padding: 6px 0; font-size: 0.75rem; text-align: center;
        }
        .ad-top-bar a { color: var(--ad-gold); text-decoration: none; font-weight: bold; }

        .nav-container {
            position: sticky; top: 0; z-index: 1000;
            background: rgba(255, 255, 255, 0.8);
            border-bottom: 1px solid var(--pico-muted-border-color);
            backdrop-filter: blur(15px);
        }
        [data-theme="dark"] .nav-container { background: rgba(17, 25, 31, 0.8); }

        .nav-icon-link {
            padding: 10px; border-radius: 12px;
            background: var(--pico-card-sectioning-background-color);
            color: var(--pico-color); display: flex; align-items: center; justify-content: center;
            border: 1px solid transparent; transition: all 0.3s ease;
            text-decoration: none;
            min-width: 42px; /* Стандартизация размера */
            height: 42px;
        }
        .nav-icon-link:hover { border-color: var(--pico-primary); transform: translateY(-1px); }

        /* --- SIDEBAR SYSTEM --- */
        #sidebar-overlay {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: rgba(0,0,0,0.5); backdrop-filter: blur(4px);
            z-index: 2000; display: none;
        }

        #mobile-sidebar {
            position: fixed; top: 0; left: -300px;
            width: var(--sidebar-width); height: 100%;
            background: var(--pico-background-color);
            z-index: 2001; transition: left 0.3s ease;
            box-shadow: 20px 0 50px rgba(0,0,0,0.1);
            padding: 20px; display: flex; flex-direction: column;
        }

        #mobile-sidebar.active { left: 0; }
        #sidebar-overlay.active { display: block; }

        .sidebar-header { display: flex; align-items: center; justify-content: space-between; margin-bottom: 1.5rem; border-bottom: 1px solid var(--pico-muted-border-color); padding-bottom: 15px; }
        
        .sidebar-menu a {
            display: flex; align-items: center; gap: 15px; padding: 12px;
            border-radius: 12px; text-decoration: none; color: var(--pico-color);
            margin-bottom: 5px; transition: 0.2s;
        }
        .sidebar-menu a:hover { background: var(--pico-card-sectioning-background-color); }
        .sidebar-menu i { font-size: 1.1rem; width: 24px; text-align: center; color: var(--pico-primary); }
        
        .unread-dot {
            position: absolute; top: 8px; right: 8px; width: 8px; height: 8px;
            background: #ff3b30; border-radius: 50%; border: 2px solid var(--pico-background-color);
        }

        @media (min-width: 992px) { .mobile-only { display: none !important; } }
        @media (max-width: 991px) { 
            .desktop-only { display: none !important; } 
            .profile-trigger { display: none !important; }
        }
    </style>
</head>
<body class="animate__animated animate__fadeIn">

    <div id="sidebar-overlay" onclick="toggleSidebar()"></div>
    <div id="mobile-sidebar">
        <div class="sidebar-header">
            <strong style="font-size: 1.2rem; display: flex; align-items: center; gap: 10px;">
                <i class="fa-solid fa-bolt-lightning" style="color:var(--pico-primary)"></i> LaiCMS
            </strong>
            <span onclick="toggleSidebar()" style="cursor:pointer; opacity: 0.6;"><i class="fa-solid fa-xmark fa-lg"></i></span>
        </div>
        <ul class="sidebar-menu">
            <li><a href="/"><i class="fa-solid fa-house"></i> Главная</a></li>
            <li><a href="/blog/index.php"><i class="fa-solid fa-shapes"></i> Блоги</a></li>
            <li><a href="/shop/ads.php"><i class="fa-solid fa-rectangle-ad" style="color:var(--ad-gold);"></i> Реклама</a></li>
            <li><a href="/users/index.php"><i class="fa-solid fa-address-book"></i> Люди</a></li>
            <?php if(isset($_SESSION['user_id'])): ?>
                <hr style="margin: 10px 0; opacity: 0.1;">
                <li><a href="/users/profile.php"><i class="fa-solid fa-user-gear"></i> Профиль (<?= htmlspecialchars($_SESSION['username']) ?>)</a></li>
                <li><a href="/messages/index.php"><i class="fa-solid fa-paper-plane"></i> Сообщения</a></li>
                <?php if(function_exists('isAdmin') && isAdmin()): ?>
                    <li><a href="/admin/index.php" style="color: #e74c3c;"><i class="fa-solid fa-gauge-high"></i> Админ-панель</a></li>
                <?php endif; ?>
                <hr style="margin: 10px 0; opacity: 0.1;">
                <li><a href="/users/logout.php" style="color: var(--pico-secondary)"><i class="fa-solid fa-door-open"></i> Выход</a></li>
            <?php else: ?>
                <hr style="margin: 10px 0; opacity: 0.1;">
                <li><a href="/users/login.php"><i class="fa-solid fa-right-to-bracket"></i> Вход</a></li>
                <li><a href="/users/register.php"><i class="fa-solid fa-user-plus"></i> Регистрация</a></li>
            <?php endif; ?>
        </ul>
    </div>

    <?php if($top_ad): ?>
    <div class="ad-top-bar">
        Рекомендуем: <a href="<?= $top_ad['link'] ?>" target="_blank"><?= htmlspecialchars($top_ad['title']) ?></a>
        <span style="opacity:0.3; margin: 0 10px;">|</span>
        <a href="/shop/ads.php" style="font-size: 0.65rem; opacity: 0.8;">Ваша реклама</a>
    </div>
    <?php endif; ?>

    <div class="nav-container">
        <nav class="container">
            <ul>
                <li>
                    <a href="javascript:void(0)" class="nav-icon-link mobile-only" onclick="toggleSidebar()">
                        <i class="fa-solid fa-bars-staggered"></i>
                    </a>
                    <a href="/" class="contrast desktop-only">
                        <i class="fa-solid fa-bolt-lightning" style="color:var(--pico-primary)"></i> <strong>LaiCMS</strong>
                    </a>
                </li>
            </ul>

            <ul>
                <li>
                    <a href="javascript:void(0)" class="nav-icon-link" onclick="toggleTheme()" title="Сменить тему">
                        <i class="fa-solid fa-circle-half-stroke"></i>
                    </a>
                </li>
                
                <?php if(isset($_SESSION['user_id'])): ?>
                    <?php $unread = function_exists('get_unread_count') ? get_unread_count($_SESSION['user_id']) : 0; ?>
                    <li>
                        <a href="/messages/index.php" class="nav-icon-link" style="position:relative;">
                            <i class="fa-solid fa-envelope"></i>
                            <?php if($unread > 0): ?><span class="unread-dot"></span><?php endif; ?>
                        </a>
                    </li>

                    <li class="desktop-only profile-trigger">
                        <details role="list" dir="rtl">
                            <summary class="nav-icon-link"><i class="fa-solid fa-user"></i></summary>
                            <ul role="listbox">
                                <li><a href="/users/profile.php">Профиль</a></li>
                                <li><a href="/blog/index.php">Блоги</a></li>
                                <li><a href="/shop/ads.php">Реклама</a></li>
                                <?php if(function_exists('isAdmin') && isAdmin()): ?>
                                    <li><a href="/admin/index.php" style="color:red">Админка</a></li>
                                <?php endif; ?>
                                <li><a href="/users/logout.php">Выйти</a></li>
                            </ul>
                        </details>
                    </li>
                <?php else: ?>
                    <li class="desktop-only"><a href="/users/login.php" class="secondary">Вход</a></li>
                    <li class="desktop-only"><a href="/users/register.php" role="button" class="primary">Регистрация</a></li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>

    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('mobile-sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        }
        function toggleTheme() {
            const html = document.documentElement;
            const next = html.getAttribute('data-theme') === 'light' ? 'dark' : 'light';
            html.setAttribute('data-theme', next);
            localStorage.setItem('theme', next);
        }
        if(localStorage.getItem('theme')) {
            document.documentElement.setAttribute('data-theme', localStorage.getItem('theme'));
        }
    </script>

    <main class="container">

