<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: system/footer.php
 * Updated: Удалена мультиязычность, оптимизация под PHP 7+, Performance Tracking.
 */

// Счётчик онлайн (5-минутный интервал)
$online_count = 0;
if (isset($mysqli)) {
    $res = $mysqli->query("SELECT COUNT(*) FROM users WHERE last_seen > NOW() - INTERVAL 5 MINUTE");
    $online_count = (int)($res->fetch_row()[0] ?? 0);
}
?>
    </main> 
    
    <footer class="container animate__animated animate__fadeInUp" style="margin-top: 80px; padding-bottom: 40px;">
        <hr style="opacity: 0.1; margin-bottom: 30px;">
        
        <div class="grid">
            <div class="footer-section">
                <h6 style="margin-bottom: 0.5rem; font-size: 1rem;">LaiCMS <span style="font-weight: 300; opacity: 0.5;">v1.0</span></h6>
                <small class="secondary">
                    &copy; <?= date('Y') ?> Все права защищены.<br>
                    Сделано с любовью.
                </small>
            </div>
            
            <div class="footer-section" style="text-align: center;">
                <div id="online-counter" 
                     style="background: var(--pico-card-sectioning-background-color); display: inline-block; padding: 10px 20px; border-radius: 50px; border: 1px solid var(--pico-muted-border-color); transition: transform 0.3s ease;">
                    <small>
                        <i class="fa-solid fa-signal" style="color: #2ecc71; margin-right: 5px;"></i> 
                        Онлайн: <a href="/users/online.php" style="font-weight: bold; text-decoration: none;"><?= $online_count ?></a>
                    </small>
                </div>
            </div>
            
            <div class="footer-section" style="text-align: right;">
                <small class="secondary">
                    <i class="fa-solid fa-server"></i> Движок: <strong>LaiCore 1.0</strong><br>
                    <i class="fa-solid fa-microchip"></i> Node: <strong><?= phpversion() ?></strong>
                </small>
            </div>
        </div>
        
        <div style="text-align: center; margin-top: 40px; border-top: 1px solid rgba(0,0,0,0.05); padding-top: 20px;">
            <a href="#" id="theme-toggle" class="secondary" style="text-decoration: none; font-size: 0.85rem;">
                <i class="fa-solid fa-circle-half-stroke"></i> <span>Сменить тему</span>
            </a>
        </div>
    </footer>

    <?php if (isset($_SESSION['flash'])): ?>
    <div id="toast-container">
        <article class="glass-toast animate__animated animate__bounceInRight">
            <div style="display: flex; align-items: center; gap: 15px;">
                <div class="toast-icon">
                    <i class="fa-solid fa-bell"></i>
                </div>
                <div class="toast-content">
                    <?= htmlspecialchars($_SESSION['flash']['msg']) ?>
                </div>
            </div>
        </article>
    </div>
    <style>
        #toast-container { position: fixed; bottom: 30px; right: 30px; z-index: 10000; }
        .glass-toast { margin: 0; padding: 12px 20px; background: rgba(255, 255, 255, 0.8) !important; backdrop-filter: blur(10px); border-left: 5px solid var(--pico-primary) !important; box-shadow: 0 15px 35px rgba(0,0,0,0.1); border-radius: 12px; }
        [data-theme="dark"] .glass-toast { background: rgba(30, 35, 45, 0.8) !important; color: #fff; }
    </style>
    <script>setTimeout(() => {
        const toast = document.getElementById('toast-container');
        if(toast) {
            toast.classList.add('animate__animated', 'animate__fadeOutRight');
            setTimeout(() => toast.remove(), 500);
        }
    }, 4000);</script>
    <?php unset($_SESSION['flash']); endif; ?>

    <script>
        // 1. Smart Theme Engine (Без зависимостей от __t)
        const html = document.documentElement;
        const themeToggle = document.getElementById('theme-toggle');
        
        const updateToggleButton = (theme) => {
            if(!themeToggle) return;
            themeToggle.querySelector('span').innerText = theme === 'dark' ? 'Светлая тема' : 'Темная тема';
            themeToggle.querySelector('i').className = theme === 'dark' ? 'fa-solid fa-sun' : 'fa-solid fa-moon';
        };

        const setTheme = (theme) => {
            html.setAttribute('data-theme', theme);
            localStorage.setItem('theme', theme);
            updateToggleButton(theme);
        };

        // Инициализация темы
        const savedTheme = localStorage.getItem('theme') || (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light');
        setTheme(savedTheme);

        if(themeToggle) {
            themeToggle.addEventListener('click', (e) => {
                e.preventDefault();
                const newTheme = html.getAttribute('data-theme') === 'dark' ? 'light' : 'dark';
                setTheme(newTheme);
            });
        }

        // 2. Performance Tracking (Web Vitals)
        window.addEventListener('load', () => {
            setTimeout(() => {
                const timing = window.performance.getEntriesByType("navigation")[0];
                if(timing) {
                    console.log(`%c LaiCore Performance: ${timing.domContentLoadedEventEnd.toFixed(0)}ms `, 'background: #4f46e5; color: #fff; border-radius: 3px; padding: 2px 5px;');
                }
            }, 0);
        });

        // 3. Улучшение UX: Предотвращение повторной отправки форм
        if (window.history.replaceState) window.history.replaceState(null, null, window.location.href);
    </script>
</body>
</html>

