<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: system/db.php
 */

declare(strict_types=1);

if (!file_exists(__DIR__ . '/config.php')) {
    header("Location: /install.php");
    exit;
}

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/core.php';

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
    $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    $mysqli->set_charset("utf8mb4");
} catch (mysqli_sql_exception $e) {
    exit("Ошибка БД. Проверьте system/config.php");
}
