<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: shop/init_payment.php
 * Description: Реальный шлюз оплаты с генерацией цифровой подписи (Secret Hash).
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_SESSION['user_id'])) {
    header("Location: deposit.php"); exit;
}

// ПАРАМЕТРЫ ПЛАТЕЖНОЙ СИСТЕМЫ (Пример для AnyPay/FreeKassa)
$merchant_id = 'ВАШ_ID_МЕРЧАНТА'; 
$secret_key  = 'ВАШ_СЕКРЕТНЫЙ_КЛЮЧ';

$user_id = (int)$_SESSION['user_id'];
$amount  = (float)$_POST['amount'];
$coins   = (int)$_POST['coins'];
$method  = $mysqli->real_escape_string($_POST['method']);

// 1. Создаем уникальный ID заказа в нашей системе
$order_id = "LAI_" . time() . "_" . $user_id;

// 2. Регистрация транзакции в БД со статусом 'pending'
$stmt = $mysqli->prepare("INSERT INTO payments (user_id, amount, coins, order_id, method, status) VALUES (?, ?, ?, ?, ?, 'pending')");
$stmt->bind_param("idiss", $user_id, $amount, $coins, $order_id, $method);

if ($stmt->execute()) {
    // 3. Генерация цифровой подписи (Signature) для защиты от подмены суммы
    // Формула зависит от провайдера, обычно: hash(merchant_id + amount + currency + secret + order_id)
    $currency = 'RUB';
    $sign = md5($merchant_id . ":" . $amount . ":" . $secret_key . ":" . $currency . ":" . $order_id);

    // 4. Формируем URL для редиректа на реальную оплату
    $payment_url = "https://anypay.io/merchant?"; // Замените на URL вашего шлюза
    $params = [
        'merchant_id' => $merchant_id,
        'amount'      => $amount,
        'pay_id'      => $order_id,
        'currency'    => $currency,
        'sign'        => $sign,
        'method'      => $method, // передаем выбранный метод (card, crypto и т.д.)
        'desc'        => "Пополнение баланса LaiCoins для пользователя ID " . $user_id
    ];

    header("Location: " . $payment_url . http_build_query($params));
    exit;
} else {
    set_flash("Ошибка БД при создании платежа", "danger");
    header("Location: deposit.php");
}

