<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: shop/history.php
 * Description: Личная история финансовых операций пользователя.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isset($_SESSION['user_id'])) { header("Location: /users/login.php"); exit; }

$user_id = (int)$_SESSION['user_id'];
$page_title = "История транзакций — LaiCMS";
include '../system/header.php';

// Получаем историю пополнений
$payments = $mysqli->query("SELECT * FROM payments WHERE user_id = $user_id ORDER BY created_at DESC LIMIT 20");
// Получаем историю трат на рекламу
$ad_costs = $mysqli->query("SELECT * FROM ads WHERE user_id = $user_id ORDER BY created_at DESC LIMIT 20");
?>

<style>
    .status-badge { padding: 3px 10px; border-radius: 50px; font-size: 0.7rem; font-weight: bold; }
    .status-completed { background: rgba(46, 204, 113, 0.2); color: #2ecc71; }
    .status-pending { background: rgba(241, 196, 15, 0.2); color: #f1c40f; }
    .type-plus { color: #2ecc71; font-weight: bold; }
    .type-minus { color: #e74c3c; font-weight: bold; }
    .history-card { border-radius: 15px; border: 1px solid var(--pico-muted-border-color); }
</style>

<div class="container animate__animated animate__fadeIn">
    <hgroup>
        <h2><i class="fa-solid fa-clock-rotate-left"></i> История финансов</h2>
        <p>Ваши доходы и расходы внутри системы</p>
    </hgroup>

    <div class="grid">
        <article class="history-card">
            <header><i class="fa-solid fa-wallet"></i> Пополнения баланса</header>
            <table class="striped">
                <thead>
                    <tr>
                        <th>Заказ</th>
                        <th>Сумма</th>
                        <th>Статус</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($payments->num_rows > 0): ?>
                        <?php while($p = $payments->fetch_assoc()): ?>
                        <tr>
                            <td><small><?= $p['order_id'] ?></small><br><small class="secondary"><?= date('d.m.y H:i', strtotime($p['created_at'])) ?></small></td>
                            <td class="type-plus">+<?= $p['coins'] ?> LC</td>
                            <td><span class="status-badge status-<?= $p['status'] ?>"><?= strtoupper($p['status']) ?></span></td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="3" style="text-align:center;">Пополнений пока не было</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </article>

        <article class="history-card">
            <header><i class="fa-solid fa-cart-shopping"></i> Траты на рекламу</header>
            <table class="striped">
                <thead>
                    <tr>
                        <th>Услуга</th>
                        <th>Расход</th>
                        <th>Дата</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($ad_costs->num_rows > 0): ?>
                        <?php while($a = $ad_costs->fetch_assoc()): ?>
                        <tr>
                            <td><?= strtoupper($a['type']) ?><br><small class="secondary">Ad #<?= $a['id'] ?></small></td>
                            <td class="type-minus">-<?= $a['cost'] ?> LC</td>
                            <td><small><?= date('d.m.y', strtotime($a['created_at'])) ?></small></td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="3" style="text-align:center;">Расходов пока не было</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </article>
    </div>
    
    <div style="text-align:center; margin-top:1rem;">
        <a href="/shop/deposit.php" role="button" class="outline primary">Пополнить баланс</a>
    </div>
</div>

<?php include '../system/footer.php'; ?>
