<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: shop/deposit.php
 * Description: Безопасное пополнение баланса.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isset($_SESSION['user_id'])) { header("Location: /users/login.php"); exit; }

$page_title = "Пополнение баланса — LaiCMS";
include '../system/header.php';

// Курс валют (например, 1 рубль = 10 LaiCoins)
$rate = 10;
?>

<style>
    .deposit-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin: 2rem 0; }
    .pack-card { 
        padding: 1.5rem; text-align: center; border-radius: 20px; 
        border: 2px solid var(--pico-muted-border-color); cursor: pointer; transition: 0.3s;
        background: var(--pico-card-background-color);
    }
    .pack-card:hover { border-color: var(--pico-primary); transform: scale(1.03); }
    .pack-card.selected { border-color: #2ecc71; background: rgba(46, 204, 113, 0.05); }
    
    .payment-methods { display: flex; gap: 15px; margin-top: 1rem; }
    .method-btn { flex: 1; padding: 10px; border-radius: 12px; border: 1px solid var(--pico-muted-border-color); text-align: center; cursor: pointer; }
    .method-btn input { display: none; }
    .method-btn:has(input:checked) { border-color: var(--pico-primary); background: rgba(var(--pico-primary-rgb), 0.1); }
</style>

<div class="container animate__animated animate__fadeIn">
    <hgroup style="text-align: center;">
        <h1>Пополнение баланса</h1>
        <p>Мгновенное зачисление через защищенный шлюз</p>
    </hgroup>

    <div class="deposit-grid">
        <div class="pack-card" onclick="selectAmount(100, 10)">
            <i class="fa-solid fa-coins" style="color:#cd7f32;"></i>
            <h4>100 LC</h4>
            <p>10.00 ₽</p>
        </div>
        <div class="pack-card selected" onclick="selectAmount(500, 50)">
            <i class="fa-solid fa-coins" style="color:#c0c0c0;"></i>
            <h4>500 LC</h4>
            <p>50.00 ₽</p>
        </div>
        <div class="pack-card" onclick="selectAmount(2000, 180)">
            <i class="fa-solid fa-coins" style="color:#ffd700;"></i>
            <h4>2000 LC</h4>
            <p>180.00 ₽ <small>(-10%)</small></p>
        </div>
    </div>

    <article class="shadow">
        <form action="init_payment.php" method="POST">
            <input type="hidden" name="amount" id="final_amount" value="50">
            <input type="hidden" name="coins" id="final_coins" value="500">
            
            <label>Способ оплаты:</label>
            <div class="payment-methods">
                <label class="method-btn">
                    <input type="radio" name="method" value="card" checked>
                    <i class="fa-solid fa-credit-card"></i><br>Карта
                </label>
                <label class="method-btn">
                    <input type="radio" name="method" value="crypto">
                    <i class="fa-brands fa-bitcoin"></i><br>Crypto
                </label>
                <label class="method-btn">
                    <input type="radio" name="method" value="sbp">
                    <i class="fa-solid fa-mobile-screen"></i><br>СБП
                </label>
            </div>

            <div style="margin-top: 2rem; border-top: 1px solid var(--pico-muted-border-color); padding-top: 1rem;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
                    <span>К зачислению: <strong id="display_coins" style="color:var(--pico-primary);">500</strong> LC</span>
                    <span>Итого к оплате: <strong id="display_price">50.00</strong> ₽</span>
                </div>
                <button type="submit" class="primary" style="width: 100%; border-radius: 50px;">
                    Перейти к оплате <i class="fa-solid fa-shield-check"></i>
                </button>
            </div>
        </form>
    </article>
</div>

<script>
function selectAmount(coins, price) {
    document.querySelectorAll('.pack-card').forEach(c => c.classList.remove('selected'));
    event.currentTarget.classList.add('selected');
    
    document.getElementById('final_amount').value = price;
    document.getElementById('final_coins').value = coins;
    document.getElementById('display_coins').innerText = coins;
    document.getElementById('display_price').innerText = price.toFixed(2);
}
</script>

<?php include '../system/footer.php'; ?>
