<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: shop/callback.php
 * Description: Безопасный Webhook для приема реальных платежей.
 */

require_once '../system/db.php';

// Конфиг безопасности
$secret_key = 'ВАШ_СЕКРЕТНЫЙ_КЛЮЧ'; // Тот же, что и в init_payment

// Получаем POST данные от агрегатора
$merchant_id = $_POST['merchant_id'] ?? '';
$amount      = $_POST['amount'] ?? '';
$order_id    = $_POST['pay_id'] ?? ''; 
$sign        = $_POST['sign'] ?? '';

// 1. ПРОВЕРКА ЦИФРОВОЙ ПОДПИСИ
$check_sign = md5($merchant_id . ":" . $amount . ":" . $order_id . ":" . $secret_key);

if ($sign !== $check_sign) {
    error_log("Security: Invalid signature attempt for order $order_id from IP " . $_SERVER['REMOTE_ADDR']);
    die("Error: Sign mismatch");
}

// 2. ПРОВЕРКА НАЛИЧИЯ ЗАКАЗА
$order_id = $mysqli->real_escape_string($order_id);
$payment = $mysqli->query("SELECT * FROM payments WHERE order_id = '$order_id' AND status = 'pending'")->fetch_assoc();

if (!$payment) {
    die("Error: Order not found or already processed");
}

// 3. ПРОВЕРКА СУММЫ (БЕЗОПАСНОСТЬ ДЕНЕГ)
if (abs((float)$payment['amount'] - (float)$amount) > 0.01) {
    die("Error: Incorrect amount");
}

// 4. ТРАНЗАКЦИОННОЕ ЗАЧИСЛЕНИЕ (ACID)
$mysqli->begin_transaction();
try {
    // Обновляем статус в истории
    $mysqli->query("UPDATE payments SET status = 'completed' WHERE id = " . $payment['id']);
    
    // Выдаем LaiCoins пользователю
    $mysqli->query("UPDATE users SET balance = balance + " . (int)$payment['coins'] . " WHERE id = " . $payment['user_id']);
    
    $mysqli->commit();
    echo "OK"; // Обязательный ответ для платежной системы
} catch (Exception $e) {
    $mysqli->rollback();
    die("Error: Transaction failed");
}

