<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: shop/ads.php
 * Description: Улучшенный маркетплейс рекламы с Live Preview и умными фильтрами.
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isset($_SESSION['user_id'])) { header("Location: /users/login.php"); exit; }

$user_id = (int)$_SESSION['user_id'];
$user_balance = $mysqli->query("SELECT balance FROM users WHERE id = $user_id")->fetch_row()[0] ?? 0;

$page_title = "Рекламная платформа — LaiCMS";
include '../system/header.php';
?>

<style>
    .plan-card {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border: 2px solid transparent;
        position: relative;
        cursor: pointer;
    }
    .plan-card:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0,0,0,0.1); }
    .plan-card.active { border-color: var(--pico-primary); background: rgba(var(--pico-primary-rgb), 0.02); }
    .plan-card.active::after {
        content: '\f058'; font-family: 'Font Awesome 6 Free'; font-weight: 900;
        position: absolute; top: 10px; right: 10px; color: var(--pico-primary);
    }

    /* Стили предпросмотра */
    .preview-box {
        border: 2px dashed var(--pico-muted-border-color);
        border-radius: 15px;
        padding: 1rem;
        margin-top: 1rem;
        background: var(--pico-card-sectioning-background-color);
    }
    .preview-label { font-size: 0.7rem; text-transform: uppercase; color: var(--pico-primary); font-weight: bold; margin-bottom: 10px; display: block; }
    
    #live_ad_preview {
        max-width: 100%;
        border-radius: 12px;
        background: var(--pico-card-background-color);
        box-shadow: var(--pico-card-box-shadow);
        overflow: hidden;
    }

    .insufficient-funds { color: #e74c3c; font-size: 0.8rem; margin-top: 10px; display: none; }
</style>

<div class="container">
    <?php if(isAdmin()): ?>
        <div class="animate__animated animate__fadeInDown" style="background: rgba(var(--pico-primary-rgb), 0.05); padding: 1rem; border-radius: 20px; margin-bottom: 2rem; border: 1px solid var(--pico-primary); display: flex; justify-content: space-between; align-items: center;">
            <span><i class="fa-solid fa-user-shield"></i> <strong>Admin Mode:</strong> Управление всеми кампаниями доступно в панели.</span>
            <a href="/admin/ads.php" role="button" class="outline shadow" style="padding: 5px 20px; margin:0; font-size: 0.8rem;">В админку</a>
        </div>
    <?php endif; ?>

    <div class="grid">
        <div style="grid-column: span 2;">
            <hgroup>
                <h2>Выберите охват</h2>
                <p>Баланс: <span id="current_balance" data-val="<?= $user_balance ?>"><?= $user_balance ?></span> LC</p>
            </hgroup>

            <div class="grid">
                <article class="plan-card" id="plan_start" onclick="selectPlan('start', 50)">
                    <i class="fa-solid fa-bolt" style="color:#f1c40f; font-size: 2rem;"></i>
                    <h4>СТАРТ</h4>
                    <p><strong>50 LC</strong> / 24 часа</p>
                    <small>Текстовая ссылка в топе</small>
                </article>

                <article class="plan-card active" id="plan_media" onclick="selectPlan('media', 250)">
                    <i class="fa-solid fa-photo-film" style="color:var(--pico-primary); font-size: 2rem;"></i>
                    <h4>МЕДИА</h4>
                    <p><strong>250 LC</strong> / 7 дней</p>
                    <small>Баннер + Описание</small>
                </article>

                <article class="plan-card" id="plan_infinity" onclick="selectPlan('infinity', 900)">
                    <i class="fa-solid fa-gem" style="color:#e67e22; font-size: 2rem;"></i>
                    <h4>ULTRA</h4>
                    <p><strong>900 LC</strong> / 30 дней</p>
                    <small>Приоритет + Баннер</small>
                </article>
            </div>

            <div class="preview-box animate__animated animate__fadeIn">
                <span class="preview-label">Предпросмотр на сайте:</span>
                <div id="live_ad_preview">
                    <div style="padding: 15px; border-left: 4px solid var(--pico-primary);">
                        <h6 id="pre_title" style="margin:0; color: var(--pico-primary);">Заголовок рекламы</h6>
                        <p id="pre_desc" class="secondary" style="font-size: 0.8rem; margin: 5px 0;">Ваш текст описания появится здесь при вводе...</p>
                        <img id="pre_img" src="https://via.placeholder.com/600x200?text=Preview+Banner" style="width:100%; height:120px; object-fit:cover; border-radius:8px; margin-top:10px; display:none;">
                    </div>
                </div>
            </div>
        </div>

        <aside>
            <article class="shadow">
                <header>Данные кампании</header>
                <form action="process_ad.php" method="POST" enctype="multipart/form-data" id="ad_purchase_form">
                    <input type="hidden" name="ad_type" id="ad_type_val" value="media">
                    
                    <label>Название
                        <input type="text" name="title" id="in_title" maxlength="40" required placeholder="Заголовок (до 40 симв.)">
                    </label>

                    <label id="desc_field">Описание
                        <textarea name="description" id="in_desc" rows="2" placeholder="Краткий призыв..."></textarea>
                    </label>

                    <label>Ссылка (URL)
                        <input type="url" name="link" required placeholder="https://mysite.com">
                    </label>

                    <label id="file_field">Баннер
                        <input type="file" name="banner" id="in_file" accept="image/*">
                    </label>

                    <div id="money_error" class="insufficient-funds">
                        <i class="fa-solid fa-triangle-exclamation"></i> Недостаточно средств на балансе.
                    </div>

                    <button type="submit" id="submit_btn" class="primary" style="width: 100%; margin-top: 1rem;">
                        Оплатить <span id="price_tag">250</span> LC
                    </button>
                </form>
            </article>
        </aside>
    </div>
</div>

<script>
const balance = parseInt(document.getElementById('current_balance').dataset.val);

function selectPlan(type, price) {
    // UI тарифов
    document.querySelectorAll('.plan-card').forEach(c => c.classList.remove('active'));
    document.getElementById('plan_' + type).classList.add('active');
    
    // Поля формы
    document.getElementById('ad_type_val').value = type;
    document.getElementById('price_tag').innerText = price;
    
    // Логика видимости полей
    const isStart = (type === 'start');
    document.getElementById('file_field').style.display = isStart ? 'none' : 'block';
    document.getElementById('pre_img').style.display = isStart ? 'none' : 'block';
    
    // Проверка кошелька
    if (balance < price) {
        document.getElementById('money_error').style.display = 'block';
        document.getElementById('submit_btn').disabled = true;
    } else {
        document.getElementById('money_error').style.display = 'none';
        document.getElementById('submit_btn').disabled = false;
    }
}

// Live Update Logic
document.getElementById('in_title').addEventListener('input', (e) => {
    document.getElementById('pre_title').innerText = e.target.value || 'Заголовок рекламы';
});

document.getElementById('in_desc').addEventListener('input', (e) => {
    document.getElementById('pre_desc').innerText = e.target.value || 'Ваш текст описания появится здесь при вводе...';
});

document.getElementById('in_file').addEventListener('change', function() {
    const file = this.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('pre_img').src = e.target.result;
            document.getElementById('pre_img').style.display = 'block';
        }
        reader.readAsDataURL(file);
    }
});

// Инициализация при загрузке
selectPlan('media', 250);
</script>

<?php include '../system/footer.php'; ?>

