<?php
/**
 * File: messages/view.php
 */
require_once '../system/db.php';
require_once '../system/functions.php';

$msg_id = (int)$_GET['id'];
$user_id = $_SESSION['user_id'];

// Получаем сообщение и проверяем права (только получатель или отправитель)
$stmt = $mysqli->prepare("
    SELECT m.*, u.username AS sender_name 
    FROM messages m 
    JOIN users u ON m.sender_id = u.id 
    WHERE m.id = ? AND (m.receiver_id = ? OR m.sender_id = ?)
");
$stmt->bind_param("iii", $msg_id, $user_id, $user_id);
$stmt->execute();
$msg = $stmt->get_result()->fetch_assoc();

if (!$msg) { die("Доступ запрещен или сообщение не существует."); }

// Помечаем как прочитанное, если открыл получатель
if ($msg['receiver_id'] == $user_id && $msg['is_read'] == 0) {
    $mysqli->query("UPDATE messages SET is_read = 1 WHERE id = $msg_id");
}

$page_title = "Чтение сообщения";
include '../system/header.php';
?>

<article style="max-width: 800px; margin: 2rem auto;">
    <header>
        <div style="display:flex; justify-content: space-between;">
            <strong>От: <?= _e($msg['sender_name']) ?></strong>
            <small><?= $msg['created_at'] ?></small>
        </div>
        <h4>Тема: <?= _e($msg['subject']) ?></h4>
    </header>
    
    <p style="white-space: pre-wrap;"><?= _e($msg['message']) ?></p>

    <footer>
        <div class="grid">
            <a href="index.php" class="secondary" role="button">Назад</a>
            <a href="compose.php?to_id=<?= $msg['sender_id'] ?>" role="button">Ответить</a>
        </div>
    </footer>
</article>

<?php include '../system/footer.php'; ?>
