<?php
require_once '../system/db.php';
require_once '../system/functions.php';

if (!isset($_SESSION['user_id'])) exit;

$my_id = $_SESSION['user_id'];
$opp_id = (int)$_POST['opp_id'];
$message = trim($_POST['message'] ?? '');
$file_path = null;

// БЕЗОПАСНАЯ ЗАГРУЗКА ФАЙЛА
if (!empty($_FILES['attachment']['name'])) {
    $file = $_FILES['attachment'];
    $allowed_ext = ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'zip', 'docx'];
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    
    // 1. Проверка расширения и размера (до 5МБ)
    if (in_array($ext, $allowed_ext) && $file['size'] < 5 * 1024 * 1024) {
        // 2. Генерация уникального имени (защита от перезаписи)
        $new_name = bin2hex(random_bytes(10)) . '.' . $ext;
        $upload_dir = '../uploads/chat/';
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
        
        if (move_uploaded_file($file['tmp_name'], $upload_dir . $new_name)) {
            $file_path = '/uploads/chat/' . $new_name;
        }
    }
}

if (!empty($message) || $file_path) {
    $stmt = $mysqli->prepare("INSERT INTO messages (sender_id, receiver_id, message, file_path, subject) VALUES (?, ?, ?, ?, 'Chat')");
    $stmt->bind_param("iiss", $my_id, $opp_id, $message, $file_path);
    $stmt->execute();
    echo json_encode(['status' => 'success']);
}
