<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: messages/get_messages_ajax.php
 * Оптимизация: PHP 7.4+, Security Patch, Prepared Statements.
 */

declare(strict_types=1);

require_once '../system/db.php';
require_once '../system/functions.php';

// 1. Проверка сессии (безопасность)
$my_id = (int)($_SESSION['user_id'] ?? 0);
if (!$my_id) {
    exit('Unauthorized');
}

// 2. Получение и фильтрация ID собеседника
$opp_id = (int)($_GET['opp_id'] ?? 0);
if ($opp_id <= 0) {
    exit('Invalid User ID');
}

/** * 3. ПОДГОТОВЛЕННЫЙ ЗАПРОС (Prepared Statement)
 * Защищает от SQL-инъекций. Выбираем историю переписки между двумя пользователями.
 * Лимит 100 последних сообщений.
 */
$stmt = $mysqli->prepare("
    SELECT sender_id, message, file_path, created_at 
    FROM messages 
    WHERE (sender_id = ? AND receiver_id = ?) 
       OR (sender_id = ? AND receiver_id = ?) 
    ORDER BY created_at ASC 
    LIMIT 100
");

$stmt->bind_param("iiii", $my_id, $opp_id, $opp_id, $my_id);
$stmt->execute();
$history = $stmt->get_result();

/**
 * 4. ЦИКЛ ВЫВОДА СООБЩЕНИЙ
 */
while ($m = $history->fetch_assoc()): 
    // Определяем, является ли текущий пользователь отправителем
    $is_me = ((int)$m['sender_id'] === $my_id);
?>
    <div class="bubble <?= $is_me ? 'me' : 'opp' ?>">
        
        <?php if (!empty($m['file_path'])): ?>
            <a href="<?= htmlspecialchars($m['file_path']) ?>" target="_blank" class="chat-file" style="display:block; margin-bottom: 5px; text-decoration: underline;">
                <i class="fa-solid fa-file-arrow-down"></i> Файл вложения
            </a>
        <?php endif; ?>

        <div class="message-text">
            <?= nl2br(htmlspecialchars((string)$m['message'])) ?>
        </div>

        <span style="font-size: 0.65rem; display:block; opacity: 0.6; text-align: right; margin-top: 4px;">
            <?= date('H:i', strtotime($m['created_at'])) ?>
        </span>
    </div>
<?php endwhile; 

// Закрываем запрос
$stmt->close();
?>

