<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: install.php
 * Description: Исправленный установщик (исправлены ошибки в именах столбцов ID).
 */

session_start();
$config_file = __DIR__ . '/system/config.php';

if (file_exists($config_file)) {
    die("Система уже установлена. Для переустановки удалите system/config.php вручную.");
}

$step = $_GET['step'] ?? 1;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'];
    $db_user = $_POST['db_user'];
    $db_pass = $_POST['db_pass'];
    $db_name = $_POST['db_name'];
    
    $admin_user = $_POST['admin_user'];
    $admin_pass = $_POST['admin_pass'];

    try {
        $mysqli = @new mysqli($db_host, $db_user, $db_pass);
        if ($mysqli->connect_error) {
            throw new Exception("Ошибка подключения: " . $mysqli->connect_error);
        }

        $mysqli->query("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        $mysqli->select_db($db_name);
        $mysqli->set_charset("utf8mb4");

        // --- СПИСОК ВСЕХ 7 ТАБЛИЦ (ИСПРАВЛЕННЫЙ) ---
        $tables = [
            // 1. Пользователи
            "CREATE TABLE IF NOT EXISTS `users` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `username` varchar(50) NOT NULL,
              `password` varchar(255) NOT NULL,
              `balance` int(11) NOT NULL DEFAULT 0,
              `role` enum('user','admin') DEFAULT 'user',
              `gender` enum('not_set','male','female') DEFAULT 'not_set',
              `avatar` varchar(255) DEFAULT NULL,
              `bio` text DEFAULT NULL,
              `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
              `last_seen` timestamp NOT NULL DEFAULT current_timestamp(),
              `last_ip` varchar(45) DEFAULT NULL,
              `last_ua` text DEFAULT NULL,
              PRIMARY KEY (`id`), UNIQUE KEY `username` (`username`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

            // 2. Категории
            "CREATE TABLE IF NOT EXISTS `categories` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `name` varchar(100) NOT NULL,
              `slug` varchar(100) NOT NULL,
              PRIMARY KEY (`id`), UNIQUE KEY `slug` (`slug`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

            // 3. Посты
            "CREATE TABLE IF NOT EXISTS `posts` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `author_id` int(11) NOT NULL,
              `category_id` int(11) DEFAULT NULL,
              `title` varchar(255) NOT NULL,
              `slug` varchar(255) NOT NULL,
              `content` text NOT NULL,
              `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
              PRIMARY KEY (`id`), UNIQUE KEY `slug` (`slug`),
              FOREIGN KEY (`author_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
              FOREIGN KEY (`category_id`) REFERENCES `categories`(`id`) ON DELETE SET NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

            // 4. Комментарии
            "CREATE TABLE IF NOT EXISTS `comments` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `post_id` int(11) NOT NULL,
              `user_id` int(11) NOT NULL,
              `comment_text` text NOT NULL,
              `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
              PRIMARY KEY (`id`),
              FOREIGN KEY (`post_id`) REFERENCES `posts`(`id`) ON DELETE CASCADE,
              FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

            // 5. Реклама
            "CREATE TABLE IF NOT EXISTS `ads` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `title` varchar(100) NOT NULL,
              `link` varchar(255) NOT NULL,
              `description` varchar(255) DEFAULT NULL,
              `image` varchar(255) DEFAULT NULL,
              `type` enum('start','media','infinity') NOT NULL,
              `cost` int(11) NOT NULL,
              `status` enum('pending','active','expired') DEFAULT 'active',
              `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
              `expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

            // 6. Платежи
            "CREATE TABLE IF NOT EXISTS `payments` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id?` int(11) NOT NULL,
              `amount` decimal(10,2) NOT NULL,
              `coins` int(11) NOT NULL,
              `order_id` varchar(100) NOT NULL,
              `status` enum('pending','completed','failed') DEFAULT 'pending',
              `method` varchar(50) DEFAULT 'card',
              `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
              PRIMARY KEY (`id`), UNIQUE KEY `order_id` (`order_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",

            // 7. Сообщения
            "CREATE TABLE IF NOT EXISTS `messages` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `sender_id` int(11) NOT NULL,
              `receiver_id` int(11) NOT NULL,
              `subject` varchar(255) DEFAULT 'Без темы',
              `message` text NOT NULL,
              `file_path` varchar(255) DEFAULT NULL,
              `is_read` tinyint(1) DEFAULT 0,
              `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
              PRIMARY KEY (`id`),
              FOREIGN KEY (`sender_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
              FOREIGN KEY (`receiver_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;"
        ];

        foreach ($tables as $sql) {
            if (!$mysqli->query($sql)) {
                throw new Exception("Ошибка при создании таблицы: " . $mysqli->error);
            }
        }

        // Создание админа
        $hashed_pass = password_hash($admin_pass, PASSWORD_DEFAULT);
        $stmt = $mysqli->prepare("INSERT IGNORE INTO users (username, password, role, balance) VALUES (?, ?, 'admin', 5000)");
        $stmt->bind_param("ss", $admin_user, $hashed_pass);
        $stmt->execute();

        // Генерация CONFIG.PHP
        $app_key = bin2hex(random_bytes(32));
        $jwt_secret = bin2hex(random_bytes(64));
        
        $config_content = "<?php\n"
            . "declare(strict_types=1);\n\n"
            . "define('DB_HOST', '$db_host');\n"
            . "define('DB_USER', '$db_user');\n"
            . "define('DB_PASS', '$db_pass');\n"
            . "define('DB_NAME', '$db_name');\n\n"
            . "define('APP_KEY', '$app_key');\n"
            . "define('JWT_SECRET', '$jwt_secret');\n"
            . "define('SITE_URL', (isset(\$_SERVER['HTTPS']) ? 'https' : 'http') . '://' . \$_SERVER['HTTP_HOST']);\n";
        
        if (!is_dir(__DIR__ . '/system')) mkdir(__DIR__ . '/system', 0755, true);
        file_put_contents($config_file, $config_content);

        $step = 'success';
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="ru" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <title>Установка LaiCMS v1.0</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@picocss/pico@1/css/pico.min.css">
    <style>body { background: #0f172a; } article { border-radius: 16px; background: #1e293b; border: none; }</style>
</head>
<body class="container" style="max-width: 600px; padding-top: 5vh;">
    <?php if ($step == 1): ?>
        <article>
            <header style="text-align: center;"><h2>🚀 LaiCMS Install</h2></header>
            <?php if ($error): ?><mark style="background:#ef4444; color:white; display:block;"><?= $error ?></mark><?php endif; ?>
            <form method="POST">
                <input type="text" name="db_host" value="localhost" placeholder="DB Host" required>
                <input type="text" name="db_name" placeholder="DB Name" required>
                <input type="text" name="db_user" placeholder="DB User" required>
                <input type="password" name="db_pass" placeholder="DB Password">
                <hr>
                <input type="text" name="admin_user" placeholder="Admin Login" required>
                <input type="password" name="admin_pass" placeholder="Admin Password" required>
                <button type="submit" style="width:100%;">УСТАНОВИТЬ</button>
            </form>
        </article>
    <?php else: ?>
        <article style="text-align:center;">
            <h2 style="color:#22c55e;">Готово!</h2>
            <p>База данных настроена, 7 таблиц созданы без ошибок.</p>
            <p><b>Удалите install.php!</b></p>
            <a href="/users/login.php" role="button">Войти</a>
        </article>
    <?php endif; ?>
</body>
</html>

