<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: index.php
 * Description: Главная страница с исправленным рендерингом превью-изображений.
 */

require_once 'system/db.php';
require_once 'system/functions.php';

// Безопасность: Валидация сессии
if (isset($_SESSION['user_id'])) {
    if (!isset($_SESSION['ua_fingerprint']) || $_SESSION['ua_fingerprint'] !== md5($_SERVER['HTTP_USER_AGENT'])) {
        session_destroy();
        header("Location: /users/login.php?error=session_compromised");
        exit;
    }
}

$page_title = "LaiCMS — Главная страница";
include 'system/header.php';

// Запросы данных
$latest_posts = $mysqli->query("SELECT p.title, p.slug, p.content, p.created_at, u.username FROM posts p JOIN users u ON p.author_id = u.id ORDER BY p.created_at DESC LIMIT 3");
$new_users = $mysqli->query("SELECT id, username, last_seen, avatar FROM users ORDER BY id DESC LIMIT 5");
$total_users = $mysqli->query("SELECT COUNT(*) FROM users")->fetch_row()[0] ?? 0;
$online_now = $mysqli->query("SELECT COUNT(*) FROM users WHERE last_seen > NOW() - INTERVAL 5 MINUTE")->fetch_row()[0] ?? 0;

/**
 * Улучшенная функция извлечения первого изображения
 */
function get_first_image($html) {
    if (preg_match('/<img.+?src=["\'](.+?)["\'].*?>/i', $html, $matches)) {
        return $matches[1];
    }
    return null; // Возвращаем null, если изображения нет
}
?>

<style>
    .hero-section { text-align: center; padding: 4rem 1rem; background: radial-gradient(circle at top right, rgba(16, 149, 193, 0.1), transparent); border-radius: 20px; margin-bottom: 2rem; }
    
    /* Сетка и карточки */
    .post-card { height: 100%; display: flex; flex-direction: column; overflow: hidden; transition: all 0.3s ease; border: 1px solid var(--pico-muted-border-color); border-radius: 16px; background: var(--pico-card-background-color); }
    .post-card:hover { transform: translateY(-8px); border-color: var(--pico-primary); box-shadow: 0 12px 30px rgba(0,0,0,0.1); }
    
    /* Контейнер для превью */
    .post-thumb-wrapper { width: 100%; height: 180px; overflow: hidden; position: relative; background: var(--pico-muted-border-color); }
    .post-thumb { width: 100%; height: 100%; object-fit: cover; }
    
    /* Заглушка, если изображения нет */
    .no-image-placeholder { 
        width: 100%; height: 100%; 
        display: flex; align-items: center; justify-content: center; 
        background: linear-gradient(45deg, var(--pico-muted-border-color), var(--pico-card-sectioning-background-color));
        color: var(--pico-muted-color);
        font-size: 2rem;
    }

    .user-avatar { width: 48px; height: 48px; border-radius: 50%; border: 2px solid var(--pico-primary); object-fit: cover; }
    .online-badge { position: absolute; bottom: 0; right: 0; width: 12px; height: 12px; background: #2ecc71; border: 2px solid var(--pico-card-background-color); border-radius: 50%; }
    .glass-card { background: rgba(255, 255, 255, 0.03); backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 16px; padding: 1.5rem; }
</style>

<section class="hero-section">
    <i class="fa-solid fa-rocket" style="color: var(--pico-primary); font-size: 3.5rem; margin-bottom: 1rem;"></i>
    <h1 style="margin-bottom: 0;">LaiCMS <span style="font-weight: 300; opacity: 0.6;">v1.0</span></h1>
    <p class="secondary">Творчество. Технологии. Сообщество.</p>
    
    <?php if(!isset($_SESSION['user_id'])): ?>
    <div style="margin-top: 1.5rem;">
        <a href="/users/register.php" role="button" class="primary" style="padding: 10px 40px; border-radius: 50px;">Создать аккаунт</a>
    </div>
    <?php endif; ?>
</section>

<div class="grid">
    <div style="grid-column: span 2;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
            <h3 style="margin:0;"><i class="fa-solid fa-feather-pointed" style="color: var(--pico-primary);"></i> Свежее в блоге</h3>
            <a href="/blog/index.php" class="secondary" style="font-size: 0.85rem;">Все публикации →</a>
        </div>

        <div class="grid">
            <?php if($latest_posts && $latest_posts->num_rows > 0): ?>
                <?php while($post = $latest_posts->fetch_assoc()): 
                    $img_url = get_first_image($post['content']);
                ?>
                    <article class="post-card" style="padding: 0; margin-bottom: 1rem;">
                        <div class="post-thumb-wrapper">
                            <?php if($img_url): ?>
                                <img src="<?= $img_url ?>" class="post-thumb" alt="<?= _e($post['title']) ?>">
                            <?php else: ?>
                                <div class="no-image-placeholder">
                                    <i class="fa-regular fa-image"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div style="padding: 1.2rem;">
                            <h5 style="margin-bottom: 0.8rem; line-height: 1.3; height: 2.6em; overflow: hidden; display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical;">
                                <?= _e($post['title']) ?>
                            </h5>
                            <p style="font-size: 0.9rem; opacity: 0.7; margin-bottom: 1.5rem; height: 3em; overflow: hidden;">
                                <?= mb_strimwidth(strip_tags($post['content']), 0, 85, "...") ?>
                            </p>
                            <div style="display: flex; justify-content: space-between; align-items: center; border-top: 1px solid var(--pico-muted-border-color); padding-top: 1rem;">
                                <small class="secondary"><i class="fa-regular fa-user-circle"></i> <?= _e($post['username']) ?></small>
                                <a href="/blog/view.php?slug=<?= $post['slug'] ?>" class="outline" role="button" style="font-size: 0.75rem; padding: 5px 15px; border-radius: 8px;">Открыть</a>
                            </div>
                        </div>
                    </article>
                <?php endwhile; ?>
            <?php else: ?>
                <article style="text-align: center; opacity: 0.5; grid-column: 1 / -1;">
                    <i class="fa-solid fa-folder-open" style="font-size: 2rem; display: block; margin-bottom: 1rem;"></i>
                    Публикаций пока нет.
                </article>
            <?php endif; ?>
        </div>
    </div>

    <div>
        <h3 style="margin-bottom: 1.5rem;"><i class="fa-solid fa-users" style="color: var(--pico-primary);"></i> Сообщество</h3>
        <article class="glass-card">
            <div style="display: flex; flex-direction: column; gap: 1.2rem;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <span class="secondary">Всего людей:</span>
                    <span class="badge contrast" style="padding: 2px 10px; border-radius: 20px;"><?= (int)$total_users ?></span>
                </div>
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <span class="secondary">В сети:</span>
                    <strong style="color: #2ecc71;"><i class="fa-solid fa-circle" style="font-size: 0.6rem;"></i> <?= (int)$online_now ?></strong>
                </div>
                
                <hr style="margin: 0.5rem 0; opacity: 0.1;">
                
                <div style="display: flex; flex-wrap: wrap; gap: 12px; justify-content: center;">
                    <?php while($u = $new_users->fetch_assoc()): 
                        $is_online = (strtotime($u['last_seen'] ?? '') > time() - 300);
                        $initial = mb_strtoupper(mb_substr($u['username'], 0, 1));
                    ?>
                        <div style="position: relative;" title="<?= _e($u['username']) ?>">
                            <?php if($u['avatar']): ?>
                                <img src="<?= $u['avatar'] ?>" class="user-avatar" alt="Avatar">
                            <?php else: ?>
                                <div class="user-avatar" style="background: var(--pico-primary); color: white; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 1.2rem;"><?= $initial ?></div>
                            <?php endif; ?>
                            <?php if($is_online): ?>
                                <span class="online-badge"></span>
                            <?php endif; ?>
                        </div>
                    <?php endwhile; ?>
                </div>
                
                <a href="/users/index.php" class="secondary outline" role="button" style="width: 100%; font-size: 0.85rem; margin-top: 0.5rem; border-radius: 12px;">Список участников</a>
            </div>
        </article>
    </div>
</div>

<hr style="margin: 4rem 0; opacity: 0.2;">

<section id="features">
    <div class="grid">
        <div style="display: flex; gap: 1rem; align-items: center;">
            <div style="background: rgba(16, 149, 193, 0.1); padding: 15px; border-radius: 12px;">
                <i class="fa-solid fa-microchip" style="font-size: 1.5rem; color: var(--pico-primary);"></i>
            </div>
            <div>
                <h6 style="margin:0;">Core Tech</h6>
                <small class="secondary">PHP 8.2 & Security First.</small>
            </div>
        </div>
        <div style="display: flex; gap: 1rem; align-items: center;">
            <div style="background: rgba(155, 89, 182, 0.1); padding: 15px; border-radius: 12px;">
                <i class="fa-solid fa-wand-magic-sparkles" style="font-size: 1.5rem; color: #9b59b6;"></i>
            </div>
            <div>
                <h6 style="margin:0;">Media Engine</h6>
                <small class="secondary">Rich content processing.</small>
            </div>
        </div>
        <div style="display: flex; gap: 1rem; align-items: center;">
            <div style="background: rgba(46, 204, 113, 0.1); padding: 15px; border-radius: 12px;">
                <i class="fa-solid fa-chart-line" style="font-size: 1.5rem; color: #2ecc71;"></i>
            </div>
            <div>
                <h6 style="margin:0;">Performance</h6>
                <small class="secondary">Optimized for speed.</small>
            </div>
        </div>
    </div>
</section>

<?php include 'system/footer.php'; ?>

