<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: admin/info.php
 * Description: Расширенный технический справочник по API и ядру LaiCMS.
 * Version: 1.0.0-STABLE
 * Security: RBAC (Admin Only).
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isAdmin()) exit("Доступ запрещен");

include '../system/header.php';
?>

<hgroup>
    <h2><i class="fa-solid fa-microchip"></i> Архитектура LaiCMS <ins>v1.0</ins></h2>
    <p>Глубокое погружение в возможности движка и современные стандарты разработки 2026 года.</p>
</hgroup>

<div class="grid">
    <article style="background: var(--pico-card-sectioning-background-color);">
        <small>Версия ядра</small>
        <div style="color: var(--pico-primary); font-weight: bold;">1.0.0 Stable</div>
    </article>
    <article style="background: var(--pico-card-sectioning-background-color);">
        <small>Режим работы</small>
        <div style="color: #2ecc71; font-weight: bold;">Production</div>
    </article>
    <article style="background: var(--pico-card-sectioning-background-color);">
        <small>API Протокол</small>
        <div style="color: #9b59b6; font-weight: bold;">REST/JSON</div>
    </article>
</div>

<article>
    <header><strong><i class="fa-solid fa-database"></i> 1. Продвинутый MySQLi (Prepared Statements)</strong></header>
    <p>В первой версии LaiCMS используется объектно-ориентированный подход к <code>mysqli</code>.</p>
    
    <div class="grid">
        <div>
            <h6>Типы данных для bind_param:</h6>
            <ul>
                <li><code>i</code> — integer</li>
                <li><code>s</code> — string</li>
                <li><code>d</code> — double</li>
                <li><code>b</code> — blob</li>
            </ul>
        </div>
        <div>
            <h6>Множественная выборка:</h6>
            <pre style="font-size: 0.7rem; background: #1a1d23; color: #abb2bf; padding: 10px; border-radius: 8px;">
$role = 'user';
$stmt = $mysqli->prepare("SELECT username, email FROM users WHERE role = ?");
$stmt->bind_param("s", $role);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    echo _e($row['username']);
}
            </pre>
        </div>
    </div>
</article>

<article>
    <header><strong><i class="fa-solid fa-cloud-arrow-down"></i> 2. Асинхронные запросы (Fetch API 2026)</strong></header>
    <p>LaiCMS v1.0 полностью отказывается от внешних JS-библиотек для сетевых запросов.</p>
    
    <pre style="font-size: 0.75rem; background: #1a1d23; color: #abb2bf; padding: 15px; border-radius: 8px;">
// JavaScript пример отправки данных (Modern Standard)
async function updateProfile(userId) {
    const response = await fetch('/api/user_update.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ 
            id: userId, 
            csrf_token: '<?= $_SESSION['csrf_token'] ?>' 
        })
    });
    
    const result = await response.json();
    if(result.status === 'success') {
        alert('Данные обновлены');
    }
}
    </pre>
    <footer>
        <small><i class="fa-solid fa-lightbulb"></i> Передавайте токен в <code>body</code> JSON-объекта.</small>
    </footer>
</article>

<article>
    <header><strong><i class="fa-solid fa-user-shield"></i> 3. Middleware и Контроль Доступа (RBAC)</strong></header>
    <p>Управление правами доступа реализовано через глобальные функции-прослойки.</p>
    <div class="grid">
        <pre style="font-size: 0.7rem; background: #282c34; color: #61afef; padding: 10px;">
// Проверка авторизации
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Проверка админ-прав
if (!isAdmin()) {
    die("Доступ запрещен");
}
        </pre>
        <div>
            <h6>Доступные роли v1.0:</h6>
            <ul>
                <li><code>admin</code> — Полный доступ</li>
                <li><code>user</code> — Личный кабинет</li>
                <li><code>guest</code> — Только чтение</li>
            </ul>
        </div>
    </div>
</article>

<article>
    <header><strong><i class="fa-solid fa-folder-tree"></i> 4. Хранение настроек и Кэширование</strong></header>
    <p>Для ускорения системы v1.0 использует JSON-файлы вместо частых запросов к БД.</p>
    
    <pre style="font-size: 0.75rem; background: #282c34; color: #61afef; padding: 15px; border-radius: 8px;">
// Сохранение настроек (Write)
$data = ['maintenance' => false, 'theme' => 'dark'];
file_put_contents('../system/config.json', json_encode($data, JSON_PRETTY_PRINT));

// Чтение настроек (Read)
$config = json_decode(file_get_contents('../system/config.json'), true);
    </pre>
</article>

<article>
    <header><strong><i class="fa-solid fa-arrow-right-arrow-left"></i> 5. Управление HTTP-контекстом</strong></header>
    <div class="grid">
        <div>
            <h6>Заголовки безопасности:</h6>
            <pre style="font-size: 0.65rem; background: #f4f4f4; padding: 8px;">
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
            </pre>
        </div>
        <div>
            <h6>Ответы API:</h6>
            <pre style="font-size: 0.65rem; background: #f4f4f4; padding: 8px;">
header('Content-Type: application/json');
echo json_encode(['res' => 'ok']);
            </pre>
        </div>
    </div>
</article>

<article>
    <header><strong><i class="fa-solid fa-list-check"></i> 6. Глобальный инструментарий LaiCMS v1.0</strong></header>
    <table role="grid">
        <thead>
            <tr>
                <th>Метод</th>
                <th>Описание</th>
                <th>Контекст</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><code>_e()</code></td>
                <td>Экранирование HTML (Anti-XSS)</td>
                <td>Вывод в браузер</td>
            </tr>
            <tr>
                <td><code>set_flash()</code></td>
                <td>Уведомление (Toast/Alert)</td>
                <td>Логика/Редиректы</td>
            </tr>
            <tr>
                <td><code>check_csrf()</code></td>
                <td>Валидация токена безопасности</td>
                <td>POST/AJAX запросы</td>
            </tr>
            <tr>
                <td><code>time_ago()</code></td>
                <td>Форматирование даты в текст</td>
                <td>Интерфейс</td>
            </tr>
        </tbody>
    </table>
</article>

<footer style="text-align: center;">
    <small>LaiCMS v1.0.0 Stable | Генерируется на базе ядра 2026 Edition</small>
</footer>

<?php include '../system/footer.php'; ?>

