<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: admin/index.php
 * Description: Глобальный командный центр (Ultra-Adaptive)
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isAdmin()) { die("403 Forbidden"); }

// Сбор статистики (Оптимизировано через подзапросы для скорости)
$stats = $mysqli->query("
    SELECT 
        (SELECT COUNT(*) FROM users) as u_count,
        (SELECT COUNT(*) FROM posts) as p_count,
        (SELECT SUM(data_length + index_length) FROM information_schema.TABLES WHERE table_schema = DATABASE()) as db_size
")->fetch_assoc();

// Получаем нагрузку на сервер (если доступно на хостинге)
$load = function_exists('sys_getloadavg') ? sys_getloadavg() : [0,0,0];

include '../system/header.php';
?>

<style>
    /* Базовая сетка и отступы */
    .dashboard-wrap { padding: 10px; max-width: 100%; overflow-x: hidden; }
    
    /* Карточки статистики с неоновым акцентом */
    .stat-card { 
        padding: 1rem; 
        border-radius: 20px; 
        background: var(--pico-card-background-color); 
        border: 1px solid var(--pico-muted-border-color);
        transition: transform 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    }
    .stat-card:hover { transform: translateY(-5px); }
    .stat-card h2 { margin: 5px 0; font-size: 1.8rem; letter-spacing: -1px; }
    
    /* Сетка управления */
    .action-grid { 
        display: grid; 
        grid-template-columns: repeat(auto-fit, minmax(160px, 1fr)); 
        gap: 12px; 
        margin-top: 1.5rem; 
    }
    .action-item { 
        display: flex; 
        flex-direction: column; 
        align-items: center; 
        justify-content: center; 
        padding: 20px; 
        background: var(--pico-card-background-color); 
        border-radius: 18px; 
        text-align: center;
        border: 1px solid var(--pico-muted-border-color);
    }
    .action-item i { font-size: 1.5rem; margin-bottom: 10px; color: var(--pico-primary); }
    .action-item span { font-size: 0.8rem; font-weight: 700; color: var(--pico-contrast); }

    /* Оптимизация для мобилок */
    @media (max-width: 600px) {
        .grid { grid-template-columns: repeat(2, 1fr) !important; } /* Статистика 2х2 */
        .action-grid { grid-template-columns: repeat(2, 1fr); } /* Кнопки 2х2 */
        .stat-card h2 { font-size: 1.4rem; }
    }
</style>

<div class="dashboard-wrap">
    <hgroup>
        <h2 style="margin:0;"><i class="fa-solid fa-rocket" style="color:var(--pico-primary);"></i> LaiCMS Console</h2>
        <p style="font-size: 0.75rem; opacity:0.7;">System Engine: <strong>PHP <?= PHP_VERSION ?></strong> | Load: <strong><?= $load[0] ?></strong></p>
    </hgroup>

    <div class="grid">
        <div class="stat-card" style="border-top: 4px solid #3498db;">
            <small class="secondary"><i class="fa-solid fa-users"></i> Юзеры</small>
            <h2><?= number_format($stats['u_count']) ?></h2>
        </div>
        <div class="stat-card" style="border-top: 4px solid #2ecc71;">
            <small class="secondary"><i class="fa-solid fa-feather"></i> Посты</small>
            <h2><?= number_format($stats['p_count']) ?></h2>
        </div>
        <div class="stat-card" style="border-top: 4px solid #f1c40f;">
            <small class="secondary"><i class="fa-solid fa-database"></i> База</small>
            <h2><?= round($stats['db_size'] / 1024 / 1024, 1) ?><small style="font-size:0.6rem;">MB</small></h2>
        </div>
        <div class="stat-card" style="border-top: 4px solid #e74c3c;">
            <small class="secondary"><i class="fa-solid fa-shield-virus"></i> Защита</small>
            <h2 style="font-size: 1.2rem; padding-top: 10px;">ACTIVE</h2>
        </div>
    </div>

    <div class="action-grid">
        <a href="/admin/blog_manage.php" class="action-item" style="text-decoration:none;">
            <i class="fa-solid fa-file-lines"></i>
            <span>Контент</span>
        </a>
        <a href="/admin/users.php" class="action-item" style="text-decoration:none;">
            <i class="fa-solid fa-user-gear"></i>
            <span>Пользователи</span>
        </a>
        <a href="/admin/ads.php" class="action-item" style="text-decoration:none;">
            <i class="fa-solid fa-rectangle-ad"></i>
            <span>Реклама</span>
        </a>
        <a href="/admin/editor.php" class="action-item" style="text-decoration:none;">
            <i class="fa-solid fa-terminal"></i>
            <span>IDE Редактор</span>
        </a>
        <a href="/admin/logs.php" class="action-item" style="text-decoration:none;">
            <i class="fa-solid fa-receipt"></i>
            <span>Логи ядра</span>
        </a>
        <a href="/admin/info.php" class="action-item" style="text-decoration:none;">
            <i class="fa-solid fa-circle-info"></i>
            <span>PHP Info</span>
        </a>
    </div>

    <article style="margin-top: 1.5rem; padding: 15px; border-radius: 18px;">
        <div style="display:flex; justify-content:space-between; align-items:center;">
            <strong style="font-size: 0.8rem;"><i class="fa-solid fa-bell"></i> Уведомления системы</strong>
            <span class="status-pill" style="background: #2ecc7122; color: #2ecc71; font-size: 0.6rem; padding: 2px 8px; border-radius: 10px;">ONLINE</span>
        </div>
        <hr style="margin: 10px 0;">
        <div style="font-size: 0.75rem; opacity: 0.8;">
            <div style="margin-bottom: 5px;"><i class="fa-solid fa-check-double" style="color:#2ecc71;"></i> Резервное копирование завершено успешно.</div>
            <div><i class="fa-solid fa-circle-info" style="color:#3498db;"></i> LaiCMS v1.0 актуальна, обновлений не требуется.</div>
        </div>
    </article>
</div>

<?php include '../system/footer.php'; ?>

