<?php
/**
 * CMS: LaiCMS (v1.0 Edition 2026)
 * File: admin/ads.php
 * Оптимизация: Ultra-Compact Hybrid Engine (Mobile First)
 */

require_once '../system/db.php';
require_once '../system/functions.php';

if (!isAdmin()) { die("403 Forbidden"); }

// Обработка действий (Prepared Statements для безопасности)
if (isset($_GET['action'], $_GET['target'])) {
    $id = (int)$_GET['target'];
    if ($_GET['action'] === 'delete') {
        $stmt = $mysqli->prepare("DELETE FROM ads WHERE id = ?");
    } else {
        $stmt = $mysqli->prepare("UPDATE ads SET status = IF(status='active', 'pending', 'active') WHERE id = ?");
    }
    $stmt->bind_param("i", $id);
    $stmt->execute();
    header("Location: ads.php"); exit;
}

$page_title = "Ad Control";
include '../system/header.php';

$ads = $mysqli->query("SELECT a.*, u.username FROM ads a JOIN users u ON a.user_id = u.id ORDER BY a.created_at DESC");
?>

<style>
    /* Глобальный фикс для мобилок */
    .ad-container { padding: 10px; max-width: 100%; overflow-x: hidden; }
    
    /* Таблица-трансформер */
    .smart-table { width: 100%; border-collapse: collapse; font-size: 0.85rem; table-layout: fixed; }
    .smart-table thead { background: var(--pico-card-background-color); }
    .smart-table th, .smart-table td { padding: 10px; border-bottom: 1px solid var(--pico-muted-border-color); overflow: hidden; text-overflow: ellipsis; }

    /* Статусы - максимально сжатые */
    .st-dot { width: 8px; height: 8px; border-radius: 50%; display: inline-block; margin-right: 5px; }
    .st-active { background: #2ecc71; box-shadow: 0 0 5px #2ecc71; }
    .st-pending { background: #f1c40f; }
    .st-expired { background: #e74c3c; }

    /* Кнопки - компактный блок */
    .action-group { display: flex; gap: 5px; }
    .btn-sm { padding: 4px 8px; font-size: 0.75rem; margin-bottom: 0; }

    /* МОБИЛЬНАЯ АДАПТАЦИЯ (Stack Mode) */
    @media screen and (max-width: 600px) {
        .smart-table thead { display: none; } /* Прячем заголовки */
        .smart-table tr { 
            display: block; 
            margin-bottom: 15px; 
            background: var(--pico-card-background-color); 
            border: 1px solid var(--pico-muted-border-color);
            border-radius: 12px;
            padding: 10px;
        }
        .smart-table td { 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            border: none; 
            padding: 5px 0;
            width: 100% !important;
            text-align: right;
        }
        /* Добавляем подписи слева на мобилках */
        .smart-table td::before { 
            content: attr(data-label); 
            font-weight: bold; 
            text-align: left; 
            font-size: 0.7rem; 
            color: var(--pico-muted-color);
            text-transform: uppercase;
        }
        .ad-info { text-align: right; }
        .ad-preview-mini { width: 30px !important; height: 30px !important; }
    }

    .ad-preview-mini { width: 40px; height: 30px; object-fit: cover; border-radius: 4px; }
</style>

<div class="ad-container">
    <hgroup>
        <h4 style="margin-bottom:5px;"><i class="fa-solid fa-microchip"></i> AdTech Lite</h4>
        <p style="font-size:0.7rem;">Управление кампаниями: <?= $ads->num_rows ?></p>
    </hgroup>

    <div class="table-wrapper">
        <table class="smart-table">
            <thead>
                <tr>
                    <th style="width: 50px;">ID</th>
                    <th>Рекламодатель</th>
                    <th style="width: 100px;">Бюджет</th>
                    <th style="width: 110px;">Статус</th>
                    <th style="width: 90px;">Действия</th>
                </tr>
            </thead>
            <tbody>
                <?php while($ad = $ads->fetch_assoc()): 
                    $expired = strtotime($ad['expires_at']) < time();
                    $status = $expired ? 'expired' : $ad['status'];
                ?>
                <tr>
                    <td data-label="ID">#<?= $ad['id'] ?></td>
                    <td data-label="Контент">
                        <div style="display:flex; align-items:center; gap:8px; justify-content: flex-end;">
                            <div class="ad-info">
                                <div style="font-weight:700;"><?= _e($ad['username']) ?></div>
                                <div style="font-size:0.65rem; opacity:0.6;"><?= mb_strimwidth(_e($ad['title']), 0, 15, "...") ?></div>
                            </div>
                            <?php if($ad['image']): ?>
                                <img src="<?= $ad['image'] ?>" class="ad-preview-mini">
                            <?php endif; ?>
                        </div>
                    </td>
                    <td data-label="Цена"><b><?= $ad['cost'] ?></b> <small>LC</small></td>
                    <td data-label="Статус">
                        <span style="font-size:0.7rem; font-weight:bold;">
                            <span class="st-dot st-<?= $status ?>"></span><?= strtoupper($status) ?>
                        </span>
                    </td>
                    <td data-label="Действия">
                        <div class="action-group">
                            <a href="?action=toggle&target=<?= $ad['id'] ?>" class="button btn-sm contrast" style="flex:1;"><i class="fa-solid fa-sync"></i></a>
                            <a href="?action=delete&target=<?= $ad['id'] ?>" class="button btn-sm secondary" style="flex:1;" onclick="return confirm('Удалить?')"><i class="fa-solid fa-trash"></i></a>
                        </div>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../system/footer.php'; ?>

