<?php
// =========================
// public/settings.php
// Настройки профиля пользователя
// =========================

require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/functions.php';

// Только авторизованные пользователи
require_login();

// Получаем данные пользователя
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
$stmt->execute(['id' => $_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Подключаем header
include __DIR__ . '/../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4 fw-bold text-center animate__animated animate__fadeInDown">Настройки аккаунта</h2>

    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-sm border-0 animate__animated animate__fadeInUp">
                <div class="card-body">
                    <form id="settings-form" class="needs-validation" novalidate>
                        <?= csrf_input(); ?>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email" required value="<?= e($user['email']) ?>">
                            <div class="invalid-feedback">Введите корректный email</div>
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label">Новый пароль <small class="text-muted">(оставьте пустым, если не меняете)</small></label>
                            <input type="password" class="form-control" id="password" name="password">
                        </div>

                        <div class="mb-3">
                            <label for="notifications" class="form-label">Уведомления по email</label>
                            <select class="form-select" id="notifications" name="notifications">
                                <option value="1" <?= $user['notifications'] ? 'selected' : '' ?>>Включены</option>
                                <option value="0" <?= !$user['notifications'] ? 'selected' : '' ?>>Выключены</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">Сохранить настройки</button>
                        <div id="settings-feedback" class="mt-2"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// =========================
// AJAX обновление настроек
// =========================
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('settings-form');
    const feedback = document.getElementById('settings-feedback');

    form.addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(form);

        fetch('<?= BASE_URL ?>ajax/settings_update.php', {
            method: 'POST',
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                feedback.innerHTML = '<div class="alert alert-success">Настройки успешно сохранены!</div>';
            } else {
                feedback.innerHTML = '<div class="alert alert-danger">' + (data.error || 'Ошибка сохранения') + '</div>';
            }
        });
    });
});
</script>

<?php
include __DIR__ . '/../includes/footer.php';
?>
