<?php
// =========================
// public/order_view.php
// Просмотр деталей одного заказа
// =========================

require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/functions.php';

// Только авторизованные пользователи
require_login();

// Получаем ID заказа из GET
$order_id = intval($_GET['id'] ?? 0);
if (!$order_id) {
    redirect(BASE_URL . 'orders.php');
}

// Получаем заказ
$stmt = $pdo->prepare("SELECT * FROM orders WHERE id = :id AND user_id = :user_id");
$stmt->execute([
    'id' => $order_id,
    'user_id' => $_SESSION['user_id']
]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    redirect(BASE_URL . 'orders.php');
}

// Получаем элементы заказа
$stmtItems = $pdo->prepare("SELECT o.*, p.filename, f.name AS format_name 
                            FROM order_items o
                            JOIN photos p ON o.photo_id = p.id
                            JOIN formats f ON o.format_id = f.id
                            WHERE o.order_id = :order_id");
$stmtItems->execute(['order_id' => $order_id]);
$items = $stmtItems->fetchAll(PDO::FETCH_ASSOC);

// Подключаем header
include __DIR__ . '/../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4 fw-bold text-center animate__animated animate__fadeInDown">Заказ #<?= e($order['id']) ?></h2>

    <div class="card shadow-sm border-0 animate__animated animate__fadeInUp">
        <div class="card-body">
            <div class="mb-3 d-flex justify-content-between align-items-center">
                <div>
                    <strong>Дата:</strong> <?= date('d.m.Y H:i', strtotime($order['created_at'])) ?><br>
                    <strong>Статус:</strong> <span class="badge bg-<?= order_status_badge($order['status']) ?>"><?= e($order['status']) ?></span>
                </div>
                <a href="<?= BASE_URL ?>orders.php" class="btn btn-outline-secondary btn-sm">Назад к заказам</a>
            </div>

            <h5 class="mb-3">Элементы заказа:</h5>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Фото</th>
                            <th>Формат</th>
                            <th>Кол-во</th>
                            <th>Цена</th>
                            <th>Итого</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($items as $item): ?>
                        <tr>
                            <td><img src="<?= BASE_URL ?>uploads/photos/<?= e($item['filename']) ?>" alt="Photo" width="60" class="rounded"></td>
                            <td><?= e($item['format_name']) ?></td>
                            <td><?= e($item['quantity']) ?></td>
                            <td><?= number_format($item['price'], 2) ?> ₽</td>
                            <td><?= number_format($item['price'] * $item['quantity'], 2) ?> ₽</td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-3 d-flex justify-content-between">
                <strong>Итоговая сумма:</strong>
                <span><?= number_format($order['total'], 2) ?> ₽</span>
            </div>

            <div class="mt-3">
                <strong>Данные доставки:</strong><br>
                <strong>ФИО:</strong> <?= e($order['fullname']) ?><br>
                <strong>Телефон:</strong> <?= e($order['phone']) ?><br>
                <strong>Адрес:</strong> <?= e($order['address']) ?>
            </div>
        </div>
    </div>
</div>

<?php
include __DIR__ . '/../includes/footer.php';
?>
