<?php
// =========================
// public/orders.php
// История заказов пользователя
// =========================

require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/functions.php';

// Только авторизованные пользователи
require_login();

// Получаем заказы пользователя
$stmt = $pdo->prepare("SELECT * FROM orders WHERE user_id = :user_id ORDER BY created_at DESC");
$stmt->execute(['user_id' => $_SESSION['user_id']]);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Подключаем header
include __DIR__ . '/../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4 fw-bold text-center animate__animated animate__fadeInDown">Мои заказы</h2>

    <?php if (empty($orders)): ?>
        <div class="alert alert-info text-center animate__animated animate__fadeInUp">
            Вы еще не сделали ни одного заказа.
        </div>
    <?php else: ?>
        <div class="accordion animate__animated animate__fadeInUp" id="ordersAccordion">
            <?php foreach ($orders as $index => $order): ?>
                <div class="accordion-item mb-2 shadow-sm border-0 rounded">
                    <h2 class="accordion-header" id="heading<?= $order['id'] ?>">
                        <button class="accordion-button <?= $index !== 0 ? 'collapsed' : '' ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?= $order['id'] ?>" aria-expanded="<?= $index === 0 ? 'true' : 'false' ?>" aria-controls="collapse<?= $order['id'] ?>">
                            Заказ #<?= e($order['id']) ?> — <?= date('d.m.Y H:i', strtotime($order['created_at'])) ?> — <span class="badge bg-<?= order_status_badge($order['status']) ?>"><?= e($order['status']) ?></span>
                        </button>
                    </h2>
                    <div id="collapse<?= $order['id'] ?>" class="accordion-collapse collapse <?= $index === 0 ? 'show' : '' ?>" aria-labelledby="heading<?= $order['id'] ?>" data-bs-parent="#ordersAccordion">
                        <div class="accordion-body">
                            <ul class="list-group list-group-flush">
                                <?php
                                $stmtItems = $pdo->prepare("SELECT o.*, p.filename, f.name AS format_name FROM order_items o 
                                                            JOIN photos p ON o.photo_id = p.id
                                                            JOIN formats f ON o.format_id = f.id
                                                            WHERE o.order_id = :order_id");
                                $stmtItems->execute(['order_id' => $order['id']]);
                                $items = $stmtItems->fetchAll(PDO::FETCH_ASSOC);
                                ?>
                                <?php foreach ($items as $item): ?>
                                    <li class="list-group-item d-flex align-items-center">
                                        <img src="<?= BASE_URL ?>uploads/photos/<?= e($item['filename']) ?>" alt="Photo" width="50" class="rounded me-3">
                                        <div>
                                            <strong><?= e($item['format_name']) ?></strong> — Кол-во: <?= e($item['quantity']) ?> — <?= number_format($item['price'] * $item['quantity'], 2) ?> ₽
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <div class="mt-3 d-flex justify-content-between">
                                <strong>Итог:</strong>
                                <span><?= number_format($order['total'], 2) ?> ₽</span>
                            </div>
                            <div class="mt-2">
                                <strong>Адрес доставки:</strong> <?= e($order['address']) ?><br>
                                <strong>Телефон:</strong> <?= e($order['phone']) ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?php
// Подключаем footer
include __DIR__ . '/../includes/footer.php';
?>
