<?php
// =========================
// public/checkout.php
// Оформление заказа
// =========================

require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/functions.php';

// Только авторизованные пользователи
require_login();

// Инициализация корзины
if (!isset($_SESSION['cart']) || empty($_SESSION['cart'])) {
    redirect(BASE_URL . 'cart.php');
}

// Подключаем header
include __DIR__ . '/../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4 fw-bold text-center animate__animated animate__fadeInDown">Оформление заказа</h2>

    <div class="row">
        <!-- Левая колонка: корзина -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 animate__animated animate__fadeInUp">
                <div class="card-body">
                    <h5 class="card-title mb-3">Ваша корзина</h5>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover align-middle" id="checkout-cart">
                            <thead class="table-light">
                                <tr>
                                    <th>Фото</th>
                                    <th>Формат</th>
                                    <th>Кол-во</th>
                                    <th>Итого</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($_SESSION['cart'] as $id => $item): ?>
                                    <tr data-id="<?= e($id) ?>">
                                        <td><img src="<?= BASE_URL ?>uploads/photos/<?= e($item['filename']) ?>" alt="Photo" width="50" class="rounded"></td>
                                        <td><?= e($item['format_name']) ?></td>
                                        <td><?= e($item['quantity']) ?></td>
                                        <td class="text-end"><?= number_format($item['price'] * $item['quantity'], 2) ?> ₽</td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-between mt-3">
                        <strong>Итого:</strong>
                        <span id="checkout-total"><?= number_format(cart_total($_SESSION['cart']), 2) ?> ₽</span>
                    </div>

                    <!-- Скидочная карта -->
                    <div class="mt-3">
                        <label for="discount_code" class="form-label">Скидочная карта (если есть)</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="discount_code" placeholder="Введите код">
                            <button class="btn btn-outline-primary" id="apply-discount">Применить</button>
                        </div>
                        <div id="discount-feedback" class="form-text text-success"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Правая колонка: данные доставки -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 animate__animated animate__fadeInUp animate__delay-1s">
                <div class="card-body">
                    <h5 class="card-title mb-3">Данные доставки</h5>
                    <form id="checkout-form" class="needs-validation" novalidate>
                        <?= csrf_input(); ?>

                        <div class="mb-3">
                            <label for="fullname" class="form-label">ФИО</label>
                            <input type="text" class="form-control" id="fullname" name="fullname" required value="<?= e($_SESSION['user_name'] ?? '') ?>">
                            <div class="invalid-feedback">Введите ФИО</div>
                        </div>

                        <div class="mb-3">
                            <label for="phone" class="form-label">Телефон</label>
                            <input type="text" class="form-control" id="phone" name="phone" required value="<?= e($_SESSION['user_phone'] ?? '') ?>">
                            <div class="invalid-feedback">Введите корректный телефон</div>
                        </div>

                        <div class="mb-3">
                            <label for="address" class="form-label">Адрес доставки</label>
                            <textarea class="form-control" id="address" name="address" rows="3" required></textarea>
                            <div class="invalid-feedback">Введите адрес</div>
                        </div>

                        <button type="submit" class="btn btn-success w-100">Оформить заказ</button>
                        <div id="checkout-feedback" class="mt-2"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// =========================
// AJAX обработка корзины и скидки
// =========================
document.addEventListener('DOMContentLoaded', function() {
    const checkoutForm = document.getElementById('checkout-form');
    const feedback = document.getElementById('checkout-feedback');
    const applyDiscountBtn = document.getElementById('apply-discount');
    const discountInput = document.getElementById('discount_code');
    const discountFeedback = document.getElementById('discount-feedback');
    const checkoutTotal = document.getElementById('checkout-total');

    // Применение скидки
    applyDiscountBtn.addEventListener('click', function(e) {
        e.preventDefault();
        const code = discountInput.value.trim();
        if (!code) return;
        fetch('<?= BASE_URL ?>ajax/apply_discount.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({code: code, csrf_token: '<?= CSRF_TOKEN ?>'})
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                checkoutTotal.textContent = data.new_total + ' ₽';
                discountFeedback.textContent = 'Скидка применена!';
            } else {
                discountFeedback.textContent = data.error;
            }
        });
    });

    // Оформление заказа
    checkoutForm.addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(checkoutForm);
        fetch('<?= BASE_URL ?>ajax/checkout.php', {
            method: 'POST',
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                feedback.innerHTML = '<div class="alert alert-success">Заказ успешно создан!</div>';
                setTimeout(() => { window.location.href = '<?= BASE_URL ?>orders.php'; }, 2000);
            } else {
                feedback.innerHTML = '<div class="alert alert-danger">' + data.error + '</div>';
            }
        });
    });
});
</script>

<?php
include __DIR__ . '/../includes/footer.php';
?>
