<?php
// =========================
// public/cart.php
// Корзина заказов
// =========================

require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/functions.php';

// Только авторизованные пользователи
require_login();

// Инициализация корзины в сессии
if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// Обработка AJAX запросов будет через JS (cart.js)

include __DIR__ . '/../includes/header.php';
?>

<div class="container py-5">
    <h2 class="mb-4 fw-bold text-center animate__animated animate__fadeInDown">Ваша корзина</h2>

    <?php if (empty($_SESSION['cart'])): ?>
        <div class="alert alert-info text-center animate__animated animate__fadeInUp">
            В корзине пока нет товаров.
        </div>
    <?php else: ?>
        <div class="table-responsive animate__animated animate__fadeInUp">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Фото</th>
                        <th>Формат</th>
                        <th>Цена</th>
                        <th>Количество</th>
                        <th>Итого</th>
                        <th>Действия</th>
                    </tr>
                </thead>
                <tbody id="cart-items">
                    <?php foreach ($_SESSION['cart'] as $id => $item): ?>
                        <tr data-id="<?= e($id) ?>">
                            <td><img src="<?= BASE_URL ?>uploads/photos/<?= e($item['filename']) ?>" alt="Photo" width="60" class="rounded"></td>
                            <td><?= e($item['format_name']) ?></td>
                            <td><?= number_format($item['price'], 2) ?> ₽</td>
                            <td>
                                <input type="number" min="1" class="form-control form-control-sm cart-quantity" value="<?= e($item['quantity']) ?>" data-id="<?= e($id) ?>">
                            </td>
                            <td class="cart-total-item"><?= number_format($item['price'] * $item['quantity'], 2) ?> ₽</td>
                            <td>
                                <button class="btn btn-sm btn-danger btn-remove-cart" data-id="<?= e($id) ?>"><i class="bi bi-trash"></i></button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-between align-items-center mt-4 animate__animated animate__fadeInUp animate__delay-1s">
            <h4>Итог: <span id="cart-total"><?= number_format(cart_total($_SESSION['cart']), 2) ?> ₽</span></h4>
            <a href="<?= BASE_URL ?>checkout.php" class="btn btn-success btn-lg">Оформить заказ</a>
        </div>
    <?php endif; ?>
</div>

<?php
include __DIR__ . '/../includes/footer.php';
?>
