<?php
require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PhotoPrint</title>
    
    <!-- Favicon -->
    <link rel="icon" href="<?= ASSETS_DIR ?>images/logo.svg" type="image/svg+xml">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?= ASSETS_DIR ?>css/bootstrap.min.css">

    <!-- Custom Styles -->
    <link rel="stylesheet" href="<?= ASSETS_DIR ?>css/style.css">
    <link rel="stylesheet" href="<?= ASSETS_DIR ?>css/dashboard.css">
    <link rel="stylesheet" href="<?= ASSETS_DIR ?>css/animations.css">

    <!-- JS глобальные переменные -->
    <script>
        window.CSRF_TOKEN = '<?= e(CSRF_TOKEN) ?>';
        window.BASE_URL = '<?= BASE_URL ?>';
    </script>
</head>
<body>
    <!-- ========================= -->
    <!-- Навигация -->
    <!-- ========================= -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="<?= BASE_URL ?>">
                <img src="<?= ASSETS_DIR ?>images/logo.svg" alt="PhotoPrint" width="40" class="me-2">
                <span class="fw-bold">PhotoPrint</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar" aria-controls="mainNavbar" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="mainNavbar">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>">Главная</a></li>
                    <?php if (is_logged_in()): ?>
                        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>profile.php">Профиль</a></li>
                        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>cart.php">Корзина</a></li>
                        <?php if (is_admin()): ?>
                            <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>admin/index.php">Админка</a></li>
                        <?php endif; ?>
                        <li class="nav-item"><a class="nav-link text-danger" href="<?= BASE_URL ?>logout.php">Выйти</a></li>
                    <?php else: ?>
                        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>login.php">Войти</a></li>
                        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>register.php">Регистрация</a></li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- ========================= -->
    <!-- Контейнер уведомлений -->
    <!-- ========================= -->
    <div id="alert-container" class="position-fixed top-0 end-0 p-3" style="z-index: 1050;"></div>

    <!-- ========================= -->
    <!-- Контейнер контента -->
    <!-- ========================= -->
    <main class="container my-4">
