<?php
// =========================
// config/session.php
// =========================

// Проверяем, не стартована ли сессия
if (session_status() === PHP_SESSION_NONE) {

    // Настройки сессии
    session_name('photoprint_session'); // имя сессии
    session_set_cookie_params([
        'lifetime' => 86400,           // 1 день
        'path' => '/',
        'domain' => $_SERVER['HTTP_HOST'],
        'secure' => isset($_SERVER['HTTPS']), // только по HTTPS
        'httponly' => true,            // защита от JS доступа
        'samesite' => 'Strict'         // защита CSRF
    ]);

    // Старт сессии
    session_start([
        'use_strict_mode' => true, // строгий режим сессии
        'cookie_httponly' => true,
        'cookie_samesite' => 'Strict'
    ]);

    // Защита от session fixation
    if (!isset($_SESSION['initiated'])) {
        session_regenerate_id(true);
        $_SESSION['initiated'] = true;
    }

}

// -------------------------
// Функция для уничтожения сессии
// -------------------------
function destroy_session() {
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params['path'], $params['domain'],
            $params['secure'], $params['httponly']
        );
    }
    session_destroy();
}

// -------------------------
// Функция для проверки авторизации
// -------------------------
function is_logged_in() {
    return isset($_SESSION['user_id']);
}

// -------------------------
// Функция для проверки роли администратора
// -------------------------
function is_admin() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}
?>
