<?php
// =========================
// config/csrf.php
// =========================

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// -------------------------
// Генерация CSRF токена
// -------------------------
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
define('CSRF_TOKEN', $_SESSION['csrf_token']);

// -------------------------
// Получить токен для формы
// -------------------------
function csrf_input() {
    return '<input type="hidden" name="csrf_token" value="' . e(CSRF_TOKEN) . '">';
}

// -------------------------
// Проверка CSRF токена
// -------------------------
function check_csrf($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// -------------------------
// Функция для безопасного вывода
// -------------------------
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// -------------------------
// Проверка POST запроса с CSRF
// -------------------------
function require_csrf() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $token = $_POST['csrf_token'] ?? '';
        if (!check_csrf($token)) {
            http_response_code(403);
            die('Ошибка безопасности (CSRF).');
        }
    }
}
?>
