<?php
// =========================
// config/auth.php
// =========================

include __DIR__ . '/bootstrap.php'; // Подключаем сессии, PDO и CSRF

// -------------------------
// Регистрация нового пользователя
// -------------------------
function register_user($pdo, $name, $email, $password) {
    // Проверка существующего пользователя
    $stmt = $pdo->prepare("SELECT id FROM users WHERE email = :email");
    $stmt->execute(['email' => $email]);
    if ($stmt->fetch()) {
        return ['success' => false, 'error' => 'Пользователь с таким email уже существует'];
    }

    // Хэшируем пароль
    $password_hash = password_hash($password, PASSWORD_DEFAULT);

    // Вставка в БД
    $stmt = $pdo->prepare("INSERT INTO users (name, email, password, role, created_at) VALUES (:name, :email, :password, 'user', NOW())");
    $stmt->execute([
        'name' => $name,
        'email' => $email,
        'password' => $password_hash
    ]);

    return ['success' => true, 'user_id' => $pdo->lastInsertId()];
}

// -------------------------
// Авторизация пользователя
// -------------------------
function login_user($pdo, $email, $password) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email LIMIT 1");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch();

    if (!$user) {
        return ['success' => false, 'error' => 'Неверный email или пароль'];
    }

    if (!password_verify($password, $user['password'])) {
        return ['success' => false, 'error' => 'Неверный email или пароль'];
    }

    // Сохраняем сессию
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['user_name'] = $user['name'];
    $_SESSION['user_email'] = $user['email'];
    $_SESSION['user_role'] = $user['role'];

    return ['success' => true, 'user' => $user];
}

// -------------------------
// Выход пользователя
// -------------------------
function logout_user() {
    session_unset();
    session_destroy();
}

// -------------------------
// Проверка авторизации
// -------------------------
function require_login() {
    if (!isset($_SESSION['user_id'])) {
        redirect('/login.php');
    }
}

// -------------------------
// Проверка администратора
// -------------------------
function require_admin() {
    if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
        redirect('/login.php');
    }
}

// -------------------------
// Проверка CSRF для форм
// -------------------------
function check_csrf_token($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

?>
