// main.js – общие функции для сайта
document.addEventListener('DOMContentLoaded', () => {
    // Авто-скролл к топу уведомлений
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => alert.remove(), 5000);
    });

    // Универсальный AJAX POST с CSRF
    window.ajaxPost = async (url, data) => {
        const response = await fetch(url, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(data)
        });
        return await response.json();
    };
});
