<?php
// ajax/upload_photo.php
require '../config/bootstrap.php';
require '../config/auth.php';

// Только авторизованные пользователи
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success'=>false, 'error'=>'Необходимо войти в систему']);
    exit;
}

// Проверка CSRF токена
$csrf = $_POST['csrf'] ?? '';
if (empty($csrf) || $csrf !== ($_SESSION['csrf'] ?? '')) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Неверный CSRF токен']);
    exit;
}

// Проверка файла
if (!isset($_FILES['photo']) || $_FILES['photo']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['success'=>false, 'error'=>'Ошибка загрузки файла']);
    exit;
}

$file = $_FILES['photo'];

// Ограничения
$max_size = 10 * 1024 * 1024; // 10MB
$allowed_types = ['image/jpeg','image/png','image/jpg'];

if ($file['size'] > $max_size) {
    echo json_encode(['success'=>false, 'error'=>'Файл слишком большой (макс 10MB)']);
    exit;
}

$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime = finfo_file($finfo, $file['tmp_name']);
finfo_close($finfo);

if (!in_array($mime, $allowed_types)) {
    echo json_encode(['success'=>false, 'error'=>'Неверный формат файла (только JPG, PNG)']);
    exit;
}

// Генерация уникального имени
$ext = pathinfo($file['name'], PATHINFO_EXTENSION);
$filename = uniqid('photo_') . '.' . $ext;

// Папка для загрузок
$upload_dir = __DIR__ . '/../uploads/photos/';
if (!is_dir($upload_dir)) mkdir($upload_dir, 0755, true);

// Перемещение файла
if (!move_uploaded_file($file['tmp_name'], $upload_dir . $filename)) {
    echo json_encode(['success'=>false, 'error'=>'Не удалось сохранить файл']);
    exit;
}

// Сохранение информации в базу
$stmt = $pdo->prepare("INSERT INTO photos (user_id, filename, status, created_at) VALUES (?, ?, 'Новый', NOW())");
$stmt->execute([$_SESSION['user_id'], $filename]);

echo json_encode([
    'success' => true,
    'photo_id' => $pdo->lastInsertId(),
    'filename' => $filename,
    'url' => '/uploads/photos/' . $filename
]);
