<?php
// ajax/cart_remove.php
require '../config/bootstrap.php';
require '../config/auth.php';

// Доступ только для авторизованных пользователей
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success'=>false, 'error'=>'Необходимо войти в систему']);
    exit;
}

// Получаем данные POST (JSON)
$data = json_decode(file_get_contents('php://input'), true);

// Проверка CSRF токена
if (empty($data['csrf']) || $data['csrf'] !== ($_SESSION['csrf'] ?? '')) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Неверный CSRF токен']);
    exit;
}

// Проверка ключа позиции корзины
$item_key = trim($data['item_key'] ?? '');
if (!$item_key || !isset($_SESSION['cart'][$item_key])) {
    echo json_encode(['success'=>false, 'error'=>'Элемент не найден в корзине']);
    exit;
}

// Удаление позиции
unset($_SESSION['cart'][$item_key]);

echo json_encode([
    'success' => true,
    'cart_count' => count($_SESSION['cart']),
    'cart_items' => $_SESSION['cart']
]);
