<?php
// ajax/admin/dashboard_stats.php
require '../../config/bootstrap.php';
require '../../config/auth.php';

// Доступ только для администратора
if (!isAdmin()) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Доступ запрещён']);
    exit;
}

// Проверка CSRF (опционально, если запрос через AJAX из админки)
$csrf = $_GET['csrf'] ?? '';
if (!empty($csrf) && $csrf !== ($_SESSION['csrf'] ?? '')) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Неверный CSRF токен']);
    exit;
}

try {
    // Количество пользователей
    $total_users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();

    // Количество заказов
    $total_orders = $pdo->query("SELECT COUNT(*) FROM orders")->fetchColumn();

    // Общая сумма заказов
    $total_revenue = $pdo->query("SELECT SUM(price * quantity) FROM orders")->fetchColumn();
    $total_revenue = $total_revenue ?: 0;

    // Загружено фотографий
    $total_photos = $pdo->query("SELECT COUNT(*) FROM photos")->fetchColumn();

    // Статистика по статусам заказов
    $stmt = $pdo->query("SELECT status, COUNT(*) as count FROM orders GROUP BY status");
    $orders_by_status = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'total_users' => intval($total_users),
        'total_orders' => intval($total_orders),
        'total_revenue' => floatval($total_revenue),
        'total_photos' => intval($total_photos),
        'orders_by_status' => $orders_by_status
    ]);
} catch (Exception $e) {
    echo json_encode(['success'=>false, 'error'=>'Ошибка получения статистики: '.$e->getMessage()]);
}
