<?php
// admin/orders.php
require '../config/bootstrap.php';
require '../config/auth.php';

if (!isAdmin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require '../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">📦 Управление заказами</h1>

    <div class="glass p-4 card-ui fade-in">
        <table class="table table-hover table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#ID</th>
                    <th>Пользователь</th>
                    <th>Фото</th>
                    <th>Формат</th>
                    <th>Скидка</th>
                    <th>Статус</th>
                    <th>Дата</th>
                    <th>Действия</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $orders = $pdo->query(
                    "SELECT o.id, u.email, o.photo_id, o.format, o.discount_code, o.status, o.created_at
                     FROM orders o
                     JOIN users u ON o.user_id = u.id
                     ORDER BY o.id DESC"
                )->fetchAll(PDO::FETCH_ASSOC);

                foreach ($orders as $order):
                ?>
                <tr>
                    <td><?= e($order['id']) ?></td>
                    <td><?= e($order['email']) ?></td>
                    <td>#<?= e($order['photo_id']) ?></td>
                    <td><?= e($order['format']) ?></td>
                    <td><?= e($order['discount_code'] ?? '-') ?></td>
                    <td>
                        <select class="form-select form-select-sm" onchange="updateStatus(<?= $order['id'] ?>, this.value)">
                            <?php
                            $statuses = ['Новый','В обработке','Печать','Доставляется','Доставлен','Отменён'];
                            foreach($statuses as $status){
                                $sel = $status == $order['status'] ? 'selected' : '';
                                echo "<option value='$status' $sel>$status</option>";
                            }
                            ?>
                        </select>
                    </td>
                    <td><?= e($order['created_at']) ?></td>
                    <td>
                        <a href="/admin/order_view.php?id=<?= $order['id'] ?>" class="btn btn-sm btn-primary">Просмотр</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
// AJAX обновление статуса заказа
function updateStatus(orderId, status){
    fetch('/ajax/admin/update_status.php', {
        method: 'POST',
        headers: {'Content-Type':'application/json'},
        body: JSON.stringify({id: orderId, status: status, csrf: '<?= $_SESSION['csrf'] ?>'})
    })
    .then(res => res.json())
    .then(data => {
        if(data.success){
            alert('Статус обновлён');
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}
</script>

<?php require '../includes/footer.php'; ?>
