<?php
// admin/index.php
require '../config/bootstrap.php';   // инициализация + сессии + безопасность
require '../config/auth.php';        // функции проверки ролей

// Проверка прав администратора
if (!isAdmin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require '../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">👑 Административная панель</h1>

    <div class="row g-4">

        <!-- Статистика заказов -->
        <div class="col-md-3">
            <div class="glass p-4 card-ui fade-in">
                <h5>📦 Заказы</h5>
                <p id="total-orders">Загрузка...</p>
            </div>
        </div>

        <!-- Пользователи -->
        <div class="col-md-3">
            <div class="glass p-4 card-ui fade-in">
                <h5>👥 Пользователи</h5>
                <p id="total-users">Загрузка...</p>
            </div>
        </div>

        <!-- Загруженные фото -->
        <div class="col-md-3">
            <div class="glass p-4 card-ui fade-in">
                <h5>🖼 Фото</h5>
                <p id="total-photos">Загрузка...</p>
            </div>
        </div>

        <!-- Активные скидки -->
        <div class="col-md-3">
            <div class="glass p-4 card-ui fade-in">
                <h5>🎫 Скидочные карты</h5>
                <p id="total-discounts">Загрузка...</p>
            </div>
        </div>
    </div>

    <!-- Прогресс выполнения заказов -->
    <div class="mt-5">
        <h4>Статусы заказов</h4>
        <div class="progress">
            <div class="progress-bar bg-success" role="progressbar" style="width:0%" id="orders-progress"></div>
        </div>
    </div>
</div>

<script>
// AJAX подгрузка статистики
function loadDashboard() {
    fetch('/ajax/admin/dashboard_stats.php')
        .then(res => res.json())
        .then(data => {
            document.getElementById('total-orders').innerText = data.orders;
            document.getElementById('total-users').innerText = data.users;
            document.getElementById('total-photos').innerText = data.photos;
            document.getElementById('total-discounts').innerText = data.discounts;

            let percent = data.orders_completed_percent || 0;
            document.getElementById('orders-progress').style.width = percent + '%';
        });
}

// Загружаем при открытии и каждые 5 секунд
loadDashboard();
setInterval(loadDashboard, 5000);
</script>

<?php require '../includes/footer.php'; ?>
