<?php
// admin/discounts.php
require '../config/bootstrap.php';
require '../config/auth.php';

if (!isAdmin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require '../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">🎫 Управление скидочными картами</h1>

    <div class="glass p-4 card-ui fade-in">
        <button class="btn btn-success mb-3" onclick="showAddDiscount()">➕ Добавить скидку</button>

        <table class="table table-hover table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#ID</th>
                    <th>Код</th>
                    <th>Скидка (%)</th>
                    <th>Активна</th>
                    <th>Действия</th>
                </tr>
            </thead>
            <tbody id="discounts-body">
                <?php
                $discounts = $pdo->query("SELECT * FROM discounts ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
                foreach ($discounts as $d):
                ?>
                <tr id="discount-<?= e($d['id']) ?>">
                    <td><?= e($d['id']) ?></td>
                    <td><?= e($d['code']) ?></td>
                    <td><?= e($d['percent']) ?>%</td>
                    <td><?= $d['active'] ? 'Да' : 'Нет' ?></td>
                    <td>
                        <button class="btn btn-sm btn-warning" onclick="editDiscount(<?= $d['id'] ?>)">✏️ Изменить</button>
                        <button class="btn btn-sm btn-danger" onclick="deleteDiscount(<?= $d['id'] ?>)">🗑️ Удалить</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Модальное окно для добавления/редактирования -->
<div class="modal" id="discountModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTitle">Добавить скидку</h5>
        <button type="button" class="btn-close" onclick="closeModal()"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="discountId">
        <div class="mb-3">
            <label>Код</label>
            <input type="text" id="discountCode" class="form-control">
        </div>
        <div class="mb-3">
            <label>Скидка (%)</label>
            <input type="number" id="discountPercent" class="form-control" min="0" max="100">
        </div>
        <div class="mb-3 form-check">
            <input type="checkbox" id="discountActive" class="form-check-input">
            <label class="form-check-label">Активна</label>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" onclick="closeModal()">Отмена</button>
        <button class="btn btn-primary" onclick="saveDiscount()">Сохранить</button>
      </div>
    </div>
  </div>
</div>

<script>
// Показ модального окна для добавления
function showAddDiscount(){
    document.getElementById('discountId').value = '';
    document.getElementById('discountCode').value = '';
    document.getElementById('discountPercent').value = '';
    document.getElementById('discountActive').checked = true;
    document.getElementById('modalTitle').innerText = 'Добавить скидку';
    document.getElementById('discountModal').style.display = 'block';
}

// Закрытие модального окна
function closeModal(){
    document.getElementById('discountModal').style.display = 'none';
}

// Редактирование скидки
function editDiscount(id){
    fetch('/ajax/admin/get_discount.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({id:id, csrf:'<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            document.getElementById('discountId').value = data.discount.id;
            document.getElementById('discountCode').value = data.discount.code;
            document.getElementById('discountPercent').value = data.discount.percent;
            document.getElementById('discountActive').checked = data.discount.active == 1;
            document.getElementById('modalTitle').innerText = 'Редактировать скидку';
            document.getElementById('discountModal').style.display = 'block';
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}

// Сохранение скидки
function saveDiscount(){
    const id = document.getElementById('discountId').value;
    const code = document.getElementById('discountCode').value;
    const percent = document.getElementById('discountPercent').value;
    const active = document.getElementById('discountActive').checked ? 1 : 0;

    fetch('/ajax/admin/save_discount.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({id:id, code:code, percent:percent, active:active, csrf:'<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            location.reload();
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}

// Удаление скидки
function deleteDiscount(id){
    if(!confirm('Удалить эту скидку?')) return;
    fetch('/ajax/admin/delete_discount.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({id:id, csrf:'<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            document.getElementById('discount-'+id).remove();
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}
</script>

<?php require '../includes/footer.php'; ?>
