<?php
// admin/analytics.php
require '../config/bootstrap.php';
require '../config/auth.php';

if (!isAdmin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require '../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">📊 Аналитика продаж</h1>

    <div class="glass p-4 card-ui fade-in">
        <div class="row g-4">

            <!-- Общие показатели -->
            <div class="col-md-3">
                <div class="card p-3">
                    <h5>📦 Всего заказов</h5>
                    <p id="total-orders">Загрузка...</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card p-3">
                    <h5>💰 Общая сумма</h5>
                    <p id="total-revenue">Загрузка...</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card p-3">
                    <h5>🖼 Фото загружено</h5>
                    <p id="total-photos">Загрузка...</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card p-3">
                    <h5>👥 Пользователей</h5>
                    <p id="total-users">Загрузка...</p>
                </div>
            </div>

        </div>

        <!-- График заказов -->
        <div class="mt-5">
            <h4>Заказы по месяцам</h4>
            <canvas id="ordersChart" height="100"></canvas>
        </div>

        <!-- График дохода -->
        <div class="mt-5">
            <h4>Доход по месяцам</h4>
            <canvas id="revenueChart" height="100"></canvas>
        </div>
    </div>
</div>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
// AJAX подгрузка статистики
function loadAnalytics() {
    fetch('/ajax/admin/analytics_stats.php')
    .then(res => res.json())
    .then(data => {
        document.getElementById('total-orders').innerText = data.total_orders;
        document.getElementById('total-revenue').innerText = data.total_revenue + ' ₽';
        document.getElementById('total-photos').innerText = data.total_photos;
        document.getElementById('total-users').innerText = data.total_users;

        // Заказы по месяцам
        const ordersCtx = document.getElementById('ordersChart').getContext('2d');
        new Chart(ordersCtx, {
            type: 'line',
            data: {
                labels: data.orders_month.labels,
                datasets: [{
                    label: 'Заказы',
                    data: data.orders_month.values,
                    backgroundColor: 'rgba(111,66,193,0.2)',
                    borderColor: 'rgba(111,66,193,1)',
                    borderWidth: 2,
                    tension: 0.3
                }]
            },
            options: { responsive: true, plugins: { legend: { display: false } } }
        });

        // Доход по месяцам
        const revenueCtx = document.getElementById('revenueChart').getContext('2d');
        new Chart(revenueCtx, {
            type: 'bar',
            data: {
                labels: data.revenue_month.labels,
                datasets: [{
                    label: 'Доход ₽',
                    data: data.revenue_month.values,
                    backgroundColor: 'rgba(111,66,193,0.6)'
                }]
            },
            options: { responsive: true, plugins: { legend: { display: false } } }
        });
    });
}

// Загружаем сразу
loadAnalytics();
</script>

<?php require '../includes/footer.php'; ?>
