using System;
using System.Collections.Generic;

namespace MTA_SDK;

public class MTA_LuaArgs
{
	private List<string> _Values = new List<string>();

	public MTA_LuaArgs()
	{
	}

	public MTA_LuaArgs(params object[] args)
	{
		for (int i = 0; i < args.Length; i++)
		{
			string text = ConvertObjToJSON(args[i]);
			if (!string.IsNullOrEmpty(text))
			{
				_Values.Add(text);
			}
		}
	}

	public void AddValue(object val)
	{
		string text = ConvertObjToJSON(val);
		if (!string.IsNullOrEmpty(text))
		{
			_Values.Add(text);
		}
	}

	private string ConvertObjToJSON(object val)
	{
		Type type = val.GetType();
		if (type == typeof(string))
		{
			return "\"" + val?.ToString() + "\"";
		}
		if (type == typeof(bool))
		{
			return val.ToString().ToLower();
		}
		if (type == typeof(int) || type == typeof(float) || type == typeof(decimal) || type == typeof(double) || type == typeof(long) || type == typeof(uint) || type == typeof(ulong) || type == typeof(float) || type == typeof(short))
		{
			return val.ToString().ToLower();
		}
		if (type == typeof(int[]))
		{
			int[] array = (int[])val;
			val = (int[])val;
			string text = "{";
			for (int i = 0; i < array.Length; i++)
			{
				if (IsValueSupported(array[i]))
				{
					text = text + "\"" + i + "\":" + ConvertObjToJSON(array[i]) + ",";
				}
			}
			text = text.TrimEnd(',');
			return text + "}";
		}
		return null;
	}

	protected bool IsValueSupported(object val)
	{
		Type type = val.GetType();
		if (type == typeof(int))
		{
			return true;
		}
		if (type == typeof(string))
		{
			return true;
		}
		if (type == typeof(bool))
		{
			return true;
		}
		if (type == typeof(int[]))
		{
			return true;
		}
		return false;
	}

	public string ConvertToJSONString()
	{
		string text = "[";
		for (int i = 0; i < _Values.Count; i++)
		{
			text = text + _Values[i] + ",";
		}
		text = text.TrimEnd(',');
		return text + "]";
	}
}
