using System;
using System.Net;

namespace MTA_SDK;

[Serializable]
public class MTARequestException : ApplicationException
{
	private WebExceptionStatus _ExceptionStatus;

	private WebResponse _Response;

	public MTARequestException()
	{
	}

	public MTARequestException(string message)
		: base(message)
	{
	}

	public MTARequestException(string message, Exception innerException)
		: base(message, innerException)
	{
	}

	public MTARequestException(string message, Exception innerException, WebExceptionStatus status, WebResponse response)
		: base(message, innerException)
	{
		_Response = response;
		_ExceptionStatus = status;
	}
}
