# FLOWAXY-CMS Wiki Documentation

Повна документація для FLOWAXY-CMS v.0.0.3 Pre.

## Структура документації

### 📚 Getting Started (3 файли)
- `Getting-Started/Installation.md` — встановлення системи
- `Getting-Started/Configuration.md` — конфігурація
- `Getting-Started/First-Steps.md` — перші кроки

### 🏗️ Architecture (6 файлів)
- `Architecture/Overview.md` — загальний огляд архітектури
- `Architecture/Core-Structure.md` — структура ядра (`flowaxy/`)
- `Architecture/Content-Structure.md` — структура контенту (`content/`)
- `Architecture/Hooks-System.md` — система хуків
- `Architecture/Routing.md` — маршрутизація
- `Architecture/Dependency-Injection.md` — DI контейнер

### 🔌 Development/Plugins (6 файлів)
- `Development/Plugins/Overview.md` — огляд системи плагінів
- `Development/Plugins/Creating-Plugin.md` — створення плагіна
- `Development/Plugins/Plugin-Lifecycle.md` — життєвий цикл плагіна
- `Development/Plugins/Plugin-Hooks.md` — робота з хуками
- `Development/Plugins/Plugin-Admin.md` — інтеграція з адмін-панеллю
- `Development/Plugins/Examples.md` — приклади плагінів

### 🎨 Development/Themes (7 файлів)
- `Development/Themes/Overview.md` — огляд системи тем
- `Development/Themes/Creating-Theme.md` — створення теми
- `Development/Themes/Theme-Structure.md` — структура теми
- `Development/Themes/Components.md` — компоненти тем
- `Development/Themes/Widgets.md` — віджети тем
- `Development/Themes/Layouts-Templates.md` — макети та шаблони
- `Development/Themes/Examples.md` — приклади тем

### 🎯 Development/Admin-Panel (4 файли)
- `Development/Admin-Panel/Overview.md` — огляд адмін-панелі
- `Development/Admin-Panel/Creating-Pages.md` — створення сторінок
- `Development/Admin-Panel/Components.md` — компоненти адмінки
- `Development/Admin-Panel/Customization.md` — кастомізація

### 📖 API-Reference (6 файлів)
- `API-Reference/Facades.md` — 36 фасадів системи
- `API-Reference/Helpers.md` — 44+ хелперів
- `API-Reference/Hooks-API.md` — API для роботи з хуками
- `API-Reference/Theme-API.md` — API для роботи з темами
- `API-Reference/Plugin-API.md` — API для роботи з плагінами
- `API-Reference/Security-API.md` — API безпеки

### 📘 Guides (2 файли)
- `Guides/Quick-Start.md` — швидкий старт
- `Guides/Best-Practices.md` — найкращі практики

### 💡 Examples (2 файли)
- `Examples/Hello-World-Plugin.md` — приклад простого плагіна
- `Examples/Simple-Theme.md` — приклад простої теми

## Всього: 37 файлів документації

## Використання

Ця документація призначена для перенесення на GitHub Wiki. Всі файли написані в Markdown форматі та готові до використання.

## Структура навігації

Головна сторінка wiki: `Home.md`

Всі інші сторінки організовані за категоріями та мають логічну структуру навігації.

---

**Документація створена для FLOWAXY-CMS v.0.0.3 Pre** 📚
