# FLOWAXY-CMS v.0.0.3 Pre

**Сучасна PHP 8.4+ CMS з архітектурою конструктора**

## Що таке FLOWAXY-CMS?

FLOWAXY-CMS — це сучасна система управління контентом, побудована на PHP 8.4+ з використанням принципів чистої архітектури та строгої ізоляції між ядром і контентом. Система спроектована для максимальної гнучкості, продуктивності та безпеки.

## Основні можливості

### 🚀 Фреймворк

-   **PHP 8.4+** — використання всіх сучасних можливостей PHP
-   **Чиста архітектура** — розділення на шари: Domain, Infrastructure, Interface
-   **Строга ізоляція** — повне розділення ядра (`flowaxy/`) та контенту (`content/`)
-   **Автоматична завантаження** — всі класи завантажуються автоматично
-   **Типобезпека** — сувора типізація, `declare(strict_types=1)` у всіх файлах
-   **Система хуків** — Actions та Filters для розширення функціональності
-   **DI контейнер** — Dependency Injection для управління залежностями

### 🔌 Плагіни

-   **Модульна архітектура** — плагіни повністю незалежні від ядра
-   **Життєвий цикл** — install, activate, deactivate, uninstall
-   **Адмін-панель** — автоматична інтеграція в адмінку
-   **Хуки та фільтри** — повна інтеграція з системою
-   **Налаштування** — зберігання в INI файлах

### 🎨 Темі

-   **Гнучка структура** — компоненти, віджети, макети, шаблони
-   **Layout система** — extend/yield pattern для макетів
-   **Компоненти** — переіспользувані блоки з власними стилями та скриптами
-   **Віджети** — блоки контенту з адаптивними стилями
-   **Кастомізація** — налаштування через адмін-панель

### 🎯 Адмін-панель

-   **Сучасний UI** — корпоративний стиль, адаптивний дизайн
-   **Компоненти** — кнопки, форми, таблиці, модальні вікна
-   **Динамічна реєстрація** — автоматичне відображення сторінок плагінів та тем
-   **Безпека** — CSRF захист, авторизація, ролі

## Швидкий старт

1. **[Встановлення](Getting-Started/Installation)** — встановіть FLOWAXY-CMS на ваш сервер
2. **[Конфігурація](Getting-Started/Configuration)** — налаштуйте систему
3. **[Перші кроки](Getting-Started/First-Steps)** — почніть роботу з системою

## Документація

### Для початківців

-   [Встановлення](Getting-Started/Installation) — покрокове встановлення
-   [Конфігурація](Getting-Started/Configuration) — налаштування системи
-   [Перші кроки](Getting-Started/First-Steps) — перші кроки після встановлення

### Архітектура

-   [Огляд архітектури](Architecture/Overview) — загальний огляд системи
-   [Структура ядра](Architecture/Core-Structure) — детальний опис `flowaxy/`
-   [Структура контенту](Architecture/Content-Structure) — детальний опис `content/`
-   [Система хуків](Architecture/Hooks-System) — Actions та Filters
-   [Маршрутизація](Architecture/Routing) — роутинг та маршрути
-   [Dependency Injection](Architecture/Dependency-Injection) — DI контейнер

### Розробка

-   [Розробка плагінів](Development/Plugins/Overview) — створення плагінів
-   [Розробка тем](Development/Themes/Overview) — створення тем
-   [Адмін-панель](Development/Admin-Panel/Overview) — розробка для адмінки

### API Reference

-   [Фасади](API-Reference/Facades) — 36 фасадів системи
-   [Хелпери](API-Reference/Helpers) — 44+ хелперів
-   [Hooks API](API-Reference/Hooks-API) — API для роботи з хуками
-   [Theme API](API-Reference/Theme-API) — API для роботи з темами
-   [Plugin API](API-Reference/Plugin-API) — API для роботи з плагінами
-   [Security API](API-Reference/Security-API) — API безпеки

### Керівництва

-   [Швидкий старт](Guides/Quick-Start) — швидке керівництво для початку роботи
-   [Найкращі практики](Guides/Best-Practices) — рекомендації з розробки

### Приклади

-   [Hello World Plugin](Examples/Hello-World-Plugin) — простий приклад плагіна
-   [Проста тема](Examples/Simple-Theme) — простий приклад теми

## Вимоги до системи

-   **PHP**: 8.4.0 або вище
-   **Розширення PHP**:
    -   `pdo` (для роботи з БД)
    -   `json` (для конфігурацій)
    -   `mbstring` (для роботи з рядками)
    -   `openssl` (для безпеки)
-   **Веб-сервер**: Apache або Nginx
-   **База даних**: MySQL 5.7+ / MariaDB 10.3+ (опціонально, система може працювати без БД)

## Версія

**v.0.0.3 Pre** — Pre-release версія з повним функціоналом для розробки та тестування.

## Ліцензія

[Вкажіть ліцензію проекту]

## Підтримка

-   **GitHub**: [посилання на репозиторій]
-   **Документація**: [посилання на документацію]
-   **Спільнота**: [посилання на спільноту]

---

**Приємної роботи з FLOWAXY-CMS!** 🚀
