# Швидкий старт

Швидке керівництво для початку роботи з FLOWAXY-CMS.

## Встановлення

### Вимоги

- PHP 8.4+
- MySQL 5.7+ або MariaDB 10.3+
- Apache/Nginx з mod_rewrite
- Composer (опціонально)

### Крок 1: Завантаження

Завантажте FLOWAXY-CMS з репозиторію або встановіть через Composer.

### Крок 2: Налаштування

1. Скопіюйте `.env.example` в `.env`
2. Налаштуйте параметри підключення до БД
3. Налаштуйте базові параметри системи

### Крок 3: Ініціалізація

Відкрийте сайт в браузері та виконайте первинну ініціалізацію через адмін-панель.

## Перші кроки

### 1. Вхід в адмін-панель

Перейдіть на `/admin` та увійдіть з обліковими даними адміністратора.

### 2. Встановлення теми

1. Перейдіть в **Темі**
2. Виберіть тему
3. Натисніть **Встановити** та **Активувати**

### 3. Встановлення плагінів

1. Перейдіть в **Плагіни**
2. Виберіть плагін
3. Натисніть **Встановити** та **Активувати**

### 4. Налаштування сайту

1. Перейдіть в **Налаштування**
2. Налаштуйте базові параметри
3. Збережіть зміни

## Створення першого плагіна

### Крок 1: Створення структури

```
content/plugins/my-plugin/
├── Plugin.php
├── admin/
│   └── pages/
│       └── my-plugin.php
└── config/
    └── plugin.ini
```

### Крок 2: Створення класу плагіна

```php
<?php
declare(strict_types=1);

use Flowaxy\Support\Base\BasePlugin;

final class Plugin extends BasePlugin
{
    public function registerHooks(): void
    {
        $this->registerAction('init', function() {
            echo 'Plugin initialized';
        });
    }
}
```

### Крок 3: Встановлення

1. Перейдіть в **Плагіни**
2. Знайдіть ваш плагін
3. Натисніть **Встановити** та **Активувати**

## Створення першої теми

### Крок 1: Створення структури

```
content/themes/my-theme/
├── Theme.php
├── templates/
│   └── default.php
└── resources/
    ├── styles/
    │   └── style.css
    └── scripts/
        └── main.js
```

### Крок 2: Створення класу теми

```php
<?php
declare(strict_types=1);

use Flowaxy\Support\Base\BaseTheme;

final class Theme extends BaseTheme
{
    public function renderTheme(): void
    {
        $this->render('default');
    }
}
```

### Крок 3: Встановлення

1. Перейдіть в **Темі**
2. Знайдіть вашу тему
3. Натисніть **Встановити** та **Активувати**

## Наступні кроки

- [Встановлення](Getting-Started/Installation) — детальне встановлення
- [Конфігурація](Getting-Started/Configuration) — налаштування системи
- [Створення плагіна](Development/Plugins/Creating-Plugin) — створення плагіна
- [Створення теми](Development/Themes/Creating-Theme) — створення теми

---

**Вітаємо! Ви готові до роботи з FLOWAXY-CMS!** 🚀
