# Встановлення FLOWAXY-CMS

Покрокове керівництво з встановлення FLOWAXY-CMS v.0.0.3 Pre на ваш сервер.

## Вимоги до системи

### Мінімальні вимоги

-   **PHP**: 8.4.0 або вище
-   **Веб-сервер**: Apache 2.4+ або Nginx 1.18+
-   **Розширення PHP**:
    -   `pdo` — для роботи з базою даних
    -   `json` — для роботи з конфігураційними файлами
    -   `mbstring` — для роботи з рядками
    -   `openssl` — для безпеки та шифрування
    -   `fileinfo` — для роботи з файлами
    -   `gd` або `imagick` — для роботи з зображеннями (опціонально)

### Опціональні вимоги

-   **База даних**: MySQL 5.7+ / MariaDB 10.3+ / PostgreSQL 10+ (система може працювати без БД)
-   **Composer**: для управління залежностями (якщо потрібно)

## Перевірка вимог

### Перевірка версії PHP

```bash
php -v
```

Має виводити версію PHP 8.4.0 або вище.

### Перевірка розширень PHP

```bash
php -m
```

Переконайтеся, що встановлені всі необхідні розширення.

## Методи встановлення

### Метод 1: Завантаження з GitHub

1. **Завантажте архів** з релізом FLOWAXY-CMS v.0.0.3 Pre
2. **Розпакуйте архів** у корінь вашого веб-сервера:
    ```
    /var/www/html/
    або
    C:\xampp\htdocs\
    ```
3. **Переконайтеся в правах доступу**:
    ```bash
    chmod -R 755 storage/
    chmod -R 755 uploads/
    ```

### Метод 2: Клонування з Git

```bash
git clone https://github.com/your-repo/flowaxy-cms.git
cd flowaxy-cms
```

## Налаштування веб-сервера

### Apache

Створіть файл `.htaccess` в корені проекту (якщо його немає):

```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteBase /
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule ^(.*)$ index.php [QSA,L]
</IfModule>
```

### Nginx

Додайте конфігурацію в ваш `nginx.conf`:

```nginx
server {
    listen 80;
    server_name your-domain.com;
    root /path/to/flowaxy-cms;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.4-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location ~ /\. {
        deny all;
    }
}
```

## Структура проекту

Після встановлення структура проекту виглядає так:

```
flowaxy-cms/
├── flowaxy/              # Ядро системи (тільки PHP класи)
├── content/              # Контент (плагіни, теми, адмінка)
│   ├── admin/           # Адмін-панель
│   ├── plugins/         # Плагіни
│   └── themes/          # Темі
├── storage/             # Зберігання даних
│   ├── config/          # Конфігураційні файли
│   ├── cache/           # Кеш
│   ├── logs/            # Логи
│   └── sessions/        # Сесії
├── uploads/             # Завантажені файли
├── index.php            # Точка входу
└── .htaccess            # Конфігурація Apache
```

## Перший запуск

1. **Відкрийте браузер** та перейдіть на адресу вашого сайту:

    ```
    http://localhost/
    або
    http://your-domain.com/
    ```

2. **Система автоматично**:

    - Створить необхідні директорії в `storage/`
    - Створить конфігураційні файли
    - Ініціалізує структуру проекту

3. **Якщо база даних не налаштована**:
    - Система працюватиме в режимі без БД
    - Root користувач може увійти в адмінку без БД
    - Налаштуйте БД через адмін-панель → Налаштування → База даних

## Налаштування прав доступу

### Linux/Unix

```bash
# Власник файлів
chown -R www-data:www-data storage/
chown -R www-data:www-data uploads/

# Права доступу
chmod -R 755 storage/
chmod -R 755 uploads/
chmod -R 644 storage/config/
```

### Windows

Переконайтеся, що IIS_IUSRS має права на запис у папки:

-   `storage/`
-   `uploads/`

## Перевірка встановлення

Після встановлення перевірте:

1. **Доступність сайту** — відкрийте головну сторінку в браузері
2. **Доступність адмінки** — перейдіть на `/admin`
3. **Створені файли** — перевірте наявність файлів у `storage/config/`

## Наступні кроки

Після успішного встановлення:

1. **[Налаштуйте конфігурацію](Configuration)** — налаштуйте систему
2. **[Виконайте перші кроки](First-Steps)** — почніть роботу з системою

## Troubleshooting

### Помилка: "Потрібна установка системи"

Якщо бачите цю помилку:

-   Перевірте права доступу до папки `storage/`
-   Переконайтеся, що PHP має права на запис
-   Перевірте наявність розширення `json` та `pdo`

### Помилка: "Class not found"

-   Перевірте версію PHP (має бути 8.4+)
-   Переконайтеся, що всі файли завантажені правильно
-   Перевірте права доступу до папки `flowaxy/`

### Помилка: "Permission denied"

```bash
# Linux/Unix
chmod -R 755 storage/
chmod -R 755 uploads/

# Перевірте власника
ls -la storage/
```

---

**Встановлення завершено!** Переходьте до [налаштування конфігурації](Configuration).
