# Перші кроки

Після встановлення та налаштування системи, виконайте ці перші кроки для початку роботи з FLOWAXY-CMS.

## 1. Вхід в адмін-панель

### Перший вхід

1. Перейдіть на адресу адмін-панелі:

    ```
    http://your-domain.com/admin
    ```

2. **Якщо база даних не налаштована**:

    - Використовуйте Root користувача для входу
    - Логін: `root`
    - Пароль: (встановіть через конфігурацію або створіть при першому запуску)

3. **Якщо база даних налаштована**:
    - Створіть адміністратора через адмін-панель → Користувачі

### Налаштування Root користувача

Root користувач дозволяє входити в адмінку без БД. Налаштування зберігаються в `storage/config/flowaxy/root-user.json`:

```json
{
    "username": "root",
    "password_hash": "$2y$10$...",
    "email": "admin@example.com"
}
```

**Важливо:** Змініть пароль Root користувача після першого входу!

## 2. Налаштування бази даних (опціонально)

### Через адмін-панель

1. Перейдіть в **Налаштування** → **База даних**
2. Введіть дані підключення:
    - Хост: `localhost`
    - Порт: `3306`
    - Назва БД: `flowaxy_db`
    - Користувач: `root`
    - Пароль: (ваш пароль)
3. Натисніть **Зберегти**

### Вручну

Створіть файл `storage/config/system/database.ini`:

```ini
[database]
host = "localhost"
port = "3306"
name = "flowaxy_db"
user = "root"
password = "your_password"
charset = "utf8mb4"
collation = "utf8mb4_unicode_ci"
```

**Примітка:** Система може працювати без БД, але деякі функції будуть недоступні.

## 3. Налаштування сайту

### Основні налаштування

1. Перейдіть в **Налаштування** → **Налаштування сайту**
2. Заповніть:
    - Назва сайту
    - URL сайту
    - Email адміністратора
    - Опис сайту
3. Натисніть **Зберегти**

### Мова та часовий пояс

1. Перейдіть в **Налаштування** → **Налаштування**
2. Встановіть:
    - Часовий пояс: `Europe/Kyiv`
    - Локаль: `uk_UA`
    - Формат дати

## 4. Активація теми

### Вибір теми

1. Перейдіть в **Тема** → **Темі**
2. Знайдіть тему `default` (або іншу)
3. Натисніть **Встановити** (якщо не встановлена)
4. Натисніть **Активувати**

### Налаштування теми

1. Перейдіть в **Тема** → **Кастомізація**
2. Налаштуйте:
    - Кольори
    - Типографіку
    - Макет
    - Header/Footer

## 5. Встановлення плагінів

### Доступні плагіни

1. Перейдіть в **Плагіни**
2. Перегляньте список доступних плагінів:
    - `social-networks` — управління соціальними мережами
    - `slider-manager` — управління слайдерами
    - `page-builder` — конструктор сторінок

### Встановлення плагіна

1. Знайдіть потрібний плагін
2. Натисніть **Встановити**
3. Натисніть **Активувати**
4. Налаштуйте плагін (якщо потрібно)

**Приклад:** Встановлення плагіна `social-networks`:

1. **Плагіни** → знайдіть `social-networks`
2. Натисніть **Встановити**
3. Натисніть **Активувати**
4. Перейдіть в **Соціальні мережі** для налаштування

## 6. Створення користувачів

### Якщо БД налаштована

1. Перейдіть в **Користувачі** → **Додати користувача**
2. Заповніть:
    - Ім'я користувача
    - Email
    - Пароль
    - Роль (Адміністратор, Редактор, тощо)
3. Натисніть **Зберегти**

### Ролі користувачів

-   **Адміністратор** — повний доступ
-   **Редактор** — редагування контенту
-   **Автор** — створення контенту
-   **Підписник** — базовий доступ

## 7. Налаштування меню

### Меню навігації

1. Перейдіть в **Тема** → **Навігація**
2. Налаштуйте:
    - Header меню
    - Footer меню
    - Бічне меню

### Області меню

Тема підтримує різні області меню:

-   `header_left` — ліве меню в header
-   `header_center` — центральне меню в header
-   `footer` — меню в footer

## 8. Перевірка роботи

### Перевірка сайту

1. Відкрийте головну сторінку сайту
2. Перевірте:
    - Відображення теми
    - Роботу компонентів
    - Адаптивність (на мобільних)

### Перевірка адмінки

1. Перевірте всі розділи адмінки:
    - Дашборд
    - Користувачі
    - Плагіни
    - Темі
    - Налаштування

## 9. Очищення кешу

Після змін у конфігурації або коді:

1. Перейдіть в **Налаштування** → **Очистити кеш**
2. Або видаліть файли в `storage/cache/` вручну

## 10. Налаштування безпеки

### CSRF захист

CSRF захист увімкнено за замовчуванням. Перевірте в `storage/config/system/security.ini`:

```ini
[security]
csrf_enabled = true
```

### Сесії

Налаштуйте час життя сесії:

```ini
[security]
session_lifetime = 7200
```

### Паролі

Мінімальна довжина пароля:

```ini
[security]
password_min_length = 8
```

## Наступні кроки

Після виконання перших кроків:

1. **[Вивчіть архітектуру](Architecture/Overview)** — зрозумійте структуру системи
2. **[Створіть плагін](Development/Plugins/Creating-Plugin)** — почніть розробку
3. **[Створіть тему](Development/Themes/Creating-Theme)** — створіть власну тему
4. **[Вивчіть API](API-Reference/Facades)** — використовуйте API системи

## Troubleshooting

### Помилка входу в адмінку

-   Перевірте правильність логіну/пароля
-   Переконайтеся, що сесії працюють
-   Перевірте права доступу до `storage/sessions/`

### Плагіни не відображаються

-   Перевірте наявність файлу `Plugin.php` в папці плагіна
-   Перевірте права доступу до `content/plugins/`
-   Очистіть кеш

### Тема не відображається

-   Перевірте, що тема активована
-   Перевірте наявність файлу `Theme.php`
-   Перевірте права доступу до `content/themes/`

---

**Вітаємо! Ви готові до роботи з FLOWAXY-CMS!** 🎉
